//
// Written by: Robert C. Pendleton
// 
// Placed in the public domain by the author.
//

#ifndef _TG_H_
#define _TG_H_

#include "ptypes.h"

#define t160x120 (0)
#define t296x220 (1)
#define t320x200 (2)
#define t320x240 (3)
#define t320x400 (4)
#define t360x360 (5)
#define t400x300 (6)

typedef struct
{
    uint16 red;
    uint16 green;
    uint16 blue;
} color;

typedef enum
{
    none,                       // no errors
    notVgaDisplay,              // it isn't a vga compatible display
    modeNotSupported,           // requested mode is not supported
    badPage,                    // invalid page requested
} tgErrors;

class tg
{
private:
    int16 origMode;             // the original video mode
    uint8 far *fontAddr;        // address of the current font

    uint8 *activeOffset;        // address of the active page

    int32 lineSize;             // offset to next scan line
    int32 pageSize;             // offset to a page

    void mode160x120();         // routines to set the tweaked modes
    void mode296x220();
    void mode320x200();
    void mode320x240();
    void mode320x400();
    void mode360x360();
    void mode400x300();

    void setTweakMode(int16 mode);
public:
    int16 error;                // the last error 

    int16 maxx;                 // maximum x coord
    int16 maxy;                 // maximum y coord

    int16 width;                // the width in pixels
    int16 height;               // the height in pixels

    int16 pages;                // the number of graphic pages

    char *modeName;             // printable name of the tweaked mode

    tg();                       // constructor
    ~tg();                      // destructor

    void mode(int16 newMode);   // select a mode
    void resetMode();           // go back to orignal mode

    void clear(uint8 color);

    void setActivePage(int16 page);
    void setVisiblePage(int16 page);

    void pixel(int16 x, int16 y, uint8 color);
    int16 pixel(int16 x, int16 y);

    void line(int16 x1, int16 y1, int16 x2, int16 y2, uint8 color);
    void fillRect(int16 x, int16 y, int16 width, int16 height, uint8 color);
    void drawChar(int16 x, int16 y, uint8 color, char c);
    void drawText(int16 x, int16 y, uint8 color, char *string);

    void setColor(int16 index, uint16 r, uint16 g, uint16 b);
    void setPalette(int16 start, int16 count, color *p);
};

#endif
