//
// Written by: Robert C. Pendleton
// 
// Copyright 1993 by Robert C. Pendleton
//
// Non-commercial use by individuals
// is permitted.
// 
//

#ifndef _VG_H_
#define _VG_H_

#include "ptypes.h"
#include "vbe.h"

typedef enum
{
    none,                   // no errors
    notVbe12,               // can't find VESA BIOS Extensions
    modeNotSupported,       // requested mode is not supported
    not8bits,               // VG only understands 8 bits modes
    badPage,                // invalid page requested
} vgErrors;

class vg
{
private:
    vbeInfo info;
    vbeModeInfo modeInfo;

    int16 origMode;
    int16 currentMode;

    int16 currentBank;

    int16 banksPerPage;
    int16 activePage;
    int16 activePageOffset;
    int16 visiblePage;

public:
    int16 error;

    int16 maxx;
    int16 maxy;

    int16 width;
    int16 height;

    vg(int16 mode);             // constructor
    ~vg();                      // destructor

    void clear(int16 color);

    int getNumPages()
    {
        return modeInfo.imagePages + 1;
    }

    void setActivePage(int16 page);
    void setVisiblePage(int16 page);

    void pixel(int16 x, int16 y, int16 color);
    void fillRect(int16 x, int16 y, int16 width, int16 height, int16 color);

};

#endif
