/*****************************************************************/
/*                                                               */
/*  DOS Test Routine for Logitec Space Mouse and MondoTronics    */
/*  Tractor combination                                          */
/*                                                               */
/*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "mouse6d.h"

main(argc,argv)
int argc;
char *argv[];
{
 int stat;            /* Status return                        */
 int x,y,z;           /* Mouse location                       */
 int roll,pitch,yaw;  /* Mouse orientation                    */
 int buttons;         /* Button and status data               */
 int port;            /* serial port 1=com1: 2=com2:          */
 int nmiss=0;         /* Number of bad mouse records returned */
 unsigned long diags; /* Diag return status                   */
 char bstat[10];      /* Status data output                   */
 int i;

 /* Make sure the user entered the right number of arguments */
 
 if(argc < 3) {
   printf("useage:%s mouse_port_numeber tractor_port_number\n",argv[0]);
   exit(1);
 }
 
 /* Initialize the mouse */
 port=atoi(argv[1]);
 init_mouse6d(port);
 diags=mouse_diags();
 if(diags != ALL_DIAGS_OK) {
   printf("Trouble with the mouse!\n");
   printf("Diagnostics have failed. %lx\n",diags);
   exit(1);
 }

 /* Initialize the tractor */
 port=atoi(argv[2]);
 init_tractor(port);

 /* clear the screen and put up some default information */
 clrscr();
 gotoxy(4,16);
 printf("Number of bad records %5d",nmiss);
 gotoxy(4,18);
 printf("Any key exits program");
 
 /* This is the main loop */
 while(!kbhit()) {
   stat=get_mouse6d(&x,&y,&z,&pitch,&roll,&yaw,&buttons);
   /* if we got a good data record */
   if(stat == 0) {
     for(i=0;i<9;i++) bstat[i]=' '; /* clear the status stuff */
     if(buttons & OUT_OF_RANGE) {
       /* set the status to out of range */
       bstat[0]='O';bstat[1]='U';bstat[2]='T';
     } else {
       /* set the status flags */
       if(buttons & FRINGE_AREA) {
         bstat[0]='F';
         pulse_tractor();  /* pulse the tractor while in fringe area */
       }
       if(buttons & SIDE_BUTTON) bstat[2]='S';
       if(buttons & LEFT_BUTTON) bstat[4]='L';
       if(buttons & MIDDLE_BUTTON) bstat[6]='M';
       if(buttons & RIGHT_BUTTON) bstat[8]='R';
     }
     /* Display the mouse data */
     bstat[9]=0;
     gotoxy(4,10);
     printf("Buttons %4x  %s",buttons,bstat);
     gotoxy(4,12);
     printf("x %6d y %6d z %6d",x,y,z);
     gotoxy(4,14);
     printf("roll %6d pitch %6d yaw %6d",roll,pitch,yaw);
   } else {
     /* report a bad data record here */
     nmiss++;
     gotoxy(4,16);
     printf("Number of bad records %5d",nmiss);
   }
 }
 close_mouse6d();
 clrscr();
 return(0);
}
