// ITC232.C

// ************************   ITC232DRIVER SYSTEM *************************
//#define ITC232MODULE 

//#include "ITC232.h"  
//#include "utils.c"

#include <windows.h>
#include <string.h>  
#include <ctype.h>

#include "logitech.h" 
#include "resource.h" 

//	GLOBAL DEFS, OBJECTS, AND CONTROL FLAG   

#define APPNAME 			"Logitech 6DOF test app"
#define SERIALPORT  		2
#define LOGITECH_DATA_READY	1


class Logitech *VR_mouse;
int	  Roll,Pitch,Yaw,Xpos,Ypos,Zpos,Buttons;  
 
BOOL  TestFlag=FALSE;

//---------------------------------------------------------------------------
// EXPORTS & FUNCTION PROTOTYPES
LRESULT _export FAR PASCAL WndProc( HWND, UINT, WPARAM, LPARAM ) ;
BOOL NEAR InitApplication( HANDLE );  
HWND NEAR InitInstance( HANDLE, int  );

//---------------------------------------------------------------------------
int _export PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpszCmdLine, int nCmdShow )
{
   MSG   msg ;
   

   if (!hPrevInstance)
      if (!InitApplication( hInstance ))
         return ( FALSE ) ;

   if (NULL ==InitInstance(hInstance, nCmdShow))
      return ( FALSE ) ; 
      
   while (GetMessage( &msg, NULL, 0, 0 ))
   { 
 		if (!TranslateMessage( &msg ) )
      	{
         	TranslateMessage( &msg ) ;
         	DispatchMessage( &msg ) ;      		
      	}
   }
   return ( (int) msg.wParam ) ;
} 
//---------------------------------------------------------------------------
BOOL NEAR InitApplication( HANDLE hInstance )
{
   WNDCLASS  wndclass;

   wndclass.style =         NULL ;
   wndclass.lpfnWndProc =   WndProc ;
   wndclass.cbClsExtra =    0 ;
   wndclass.cbWndExtra =    sizeof( WORD ) ;
   wndclass.hInstance =     (HINSTANCE)hInstance ;
   wndclass.hIcon =         LoadIcon( (HINSTANCE)hInstance, MAKEINTRESOURCE( MENUTEST6DOF ) );
   wndclass.hCursor =       LoadCursor( NULL, IDC_ARROW ) ;
   wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1) ;
   wndclass.lpszMenuName =  MAKEINTRESOURCE( MENUTEST6DOF ) ;
   wndclass.lpszClassName = APPNAME;

   return( RegisterClass( &wndclass ) ) ;

} // end of InitApplication()
//---------------------------------------------------------------------------
HWND NEAR InitInstance( HANDLE hInstance, int nCmdShow )
{   
	HWND hMainWindow;
	
   	hMainWindow=CreateWindow( APPNAME, APPNAME,WS_OVERLAPPEDWINDOW,CW_USEDEFAULT, 
   					CW_USEDEFAULT,500, 150,NULL, NULL,(HINSTANCE)hInstance,NULL);

   	if (NULL == hMainWindow)
      return ( NULL ) ;

   	ShowWindow( hMainWindow, nCmdShow ) ;
   	UpdateWindow( hMainWindow ) ;

   	return ( hMainWindow ) ;
} // end of InitInstance()

//---------------------------------------------------------------------------
    
LRESULT _export FAR PASCAL WndProc( HWND hWnd, UINT uMsg,WPARAM wParam, LPARAM lParam )
{   
   	switch (uMsg)
   	{
      	case WM_CREATE: 
   			VR_mouse = new Logitech(hWnd,SERIALPORT);   		
     		return(TRUE) ;  
      	break;   
      	
      	case WM_COMMNOTIFY:
      		VR_mouse->ProcessCommNotify();
      	break;                 
      
	  	case WM_TIMER:  
	  		KillTimer(hWnd,NULL); 
	  		VR_mouse->Request6DOF(hWnd,WM_COMMAND,LOGITECH_DATA_READY);
      	break ;

      	case WM_COMMAND:
      	{
         	switch (wParam)
         	{                          
         		case LOGITECH_DATA_READY:
         			if( ! VR_mouse->Get6DOF(&Roll,&Pitch,&Yaw,&Xpos,&Ypos,&Zpos,&Buttons) )
         				MessageBox(hWnd,"Mouse Error","",MB_ICONEXCLAMATION);         			        	
					InvalidateRect(hWnd,NULL,TRUE);
	           		UpdateWindow(hWnd);
            	break;  
            
            	case START_TEST:
            		TestFlag=TRUE;
            		SetTimer(hWnd,NULL,100,NULL);   
            	break;
            
            	case END_TEST:
            		TestFlag=FALSE;
            		KillTimer(hWnd,NULL);
            	break;

            	case EXIT:
               		PostMessage( hWnd, WM_CLOSE, NULL, 0L ) ;
            	break ;
         	}
      	}
      	break ;

      	case WM_DESTROY:
        	PostQuitMessage(0);         
      	break ;                  
      
		case WM_PAINT:
      	{
      		HDC hdc;   
      		PAINTSTRUCT ps;  
      		char buffer[101];

			hdc=BeginPaint(hWnd,&ps);
		
			if(TestFlag)  
			{
				wsprintf(buffer,"Testing ...");
				TextOut(hdc,10,10,(LPCSTR)buffer,lstrlen(buffer));
			}
			wsprintf(buffer,"Roll  =%4d        Pitch =%4d        Yaw =%4d",Roll,Pitch,Yaw);
			TextOut(hdc,10,30,(LPCSTR)buffer,lstrlen(buffer));
			wsprintf(buffer,"Xpos =%4d         Ypos =%4d       Zpos =%4d   Buttons=%d",Xpos,Ypos,Zpos,Buttons); 
			TextOut(hdc,10,60,(LPCSTR)buffer,lstrlen(buffer));
		
			EndPaint(hWnd,&ps);                      
			
			if(TestFlag)  
            	SetTimer(hWnd,NULL,100,NULL);
		}	
		break;

      	default:
        	return( DefWindowProc( hWnd, uMsg, wParam, lParam ) ) ;
   }
   return 0L ;
}
