/*+
    Name:       HLBENCH.C
    Author:     Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Date:       April 1988
    Abstract:	This program is the menu driver for the benchmarks.
    History:	09-Sep-88   kjq     Version 1.00
-*/

#include <stdio.h>
#include <malloc.h>
#include <process.h>
#include <graph.h>
#include <conio.h>
#include <string.h>
#include <errno.h>

#include "winmenu.h"

extern int errno;
extern char *sys_errlist[];

#define hbound(a) (sizeof(a)/sizeof(a[0]))

char file_rename[40];

char *menu[] = {			/* text for the main menu */
    "Text Scrolling -- DOS/BIOS/C",
    "Text Windows -- direct video access",
    "Graphics Video -- lines, fills, graphs",
    "CPU Speed -- Sort test",
    "Floating Point -- FFT",
    "Disk Speed -- Database test",
    "Run all above tests",
    "Display and compare results",
    "Describe this machine",
    "Save data file", 
    "Return to DOS",
    "About these benchmarks",
    NULL
};

#define S_EXECUTABLE	1	/* option flags for the various items */
#define S_OPTION        2
#define S_SHOW_RESULTS  4
#define S_GROUP_TEST    8
#define S_ANALYZE      16
#define S_RUN_ALL      32
#define S_QUIT	       64
#define S_HELP	      128
#define S_RENAME      256
#define S_DESCR       512

typedef struct Prog {		/* structure to define option flags */
    char *program, *options;
    int status;
} PROG;

PROG prog[] = { 		/* the order of these must agree w/menu */
    {"hltext",   "-F%s -P1",  S_EXECUTABLE | S_GROUP_TEST | S_SHOW_RESULTS },
    {"hlwindow", "-F%s -P2",  S_EXECUTABLE | S_GROUP_TEST | S_SHOW_RESULTS },
    {"hlgraph",  "-F%s -P3",  S_EXECUTABLE | S_GROUP_TEST | S_SHOW_RESULTS },
    {"hlsort",   "-F%s -P4",  S_EXECUTABLE | S_GROUP_TEST | S_SHOW_RESULTS },
    {"hlfloat",  "-F%s -P5",  S_EXECUTABLE | S_GROUP_TEST | S_SHOW_RESULTS },
    {"hldisk",   "-F%s -P6",  S_EXECUTABLE | S_GROUP_TEST | S_SHOW_RESULTS },
    { NULL,       NULL,       S_OPTION     | S_RUN_ALL },
    {"hlanalyz", "-F%s -S%s", S_EXECUTABLE | S_ANALYZE },
    {"hldesc",	 "-F%s -P0",  S_EXECUTABLE | S_DESCR},
    { NULL,	  NULL,       S_OPTION	   | S_RENAME },
    { NULL,       NULL,       S_OPTION     | S_QUIT },
    { NULL,	  NULL,       S_OPTION	   | S_HELP },
    { NULL,       NULL }
};

/**** u s a g e ****
    Abstract:	Prints brief usage info and exits
    Parameters: None
    Returns:	Never
****************************/
void usage()
{
    printf("This program controls the PC Tech Journal Benchmark Suite.\n");
    printf("Type HLBENCH to run the benchmarks.  If you specify a filename\n");
    printf("on the command line, that file is used for the benchmark data.\n");
    printf("If you specify a second filename, it is used as the name of the\n");
    printf("cross-reference file.  These filenames default to CURRENT and\n");
    printf("the filename specified in XREF.TXT.\n");
    printf("Examples:  HLBENCH\n");
    printf("           HLBENCH MODEL80         [name this test MODEL80]\n");
    printf("           HLBENCH MODEL80 MODEL60 [compare MODEL80 to MODEL60]\n");
    exit(1);
}

/**** t e x t _ d i s p l a y ****
    Abstract:	Given a filename of a screen image file, this copies its
		contents to the video buffer.
    Parameters: char *fname - the filename containing the data
    Returns:	Returns non-zero if unable to display text file.
****************************/
int text_display(char *fname)
{
    FILE *f;

    if ((f = fopen(fname, "rb")) == NULL)
	return(-1);
    fill_screen(f);
    fclose(f);
    return(0);
}

/**** h e l p ****
    Abstract:	Displays scrollable help text in a window.  The user can
		scroll it with up/down/pgup/pgdn.  Esc/Enter returns and
		takes away the window.
    Parameters: The filename containing the help text, the maximum number
		of lines in that file.
    Returns:	Nothing.
****************************/
void help(char *fname, int nlines, char *title)
{
    FILE *f;
    int linecnt = 0;
    char buf[100], *bp;
    char **lines;
    int i;
    
    if ((f = fopen(fname, "r")) == NULL)
    {
	sprintf(buf, "Unable to find help file %s.", fname);
	pop_error(buf);
	return;
    }
	
    lines = calloc(nlines+1, sizeof(char *));
    
    while ((bp = fgets(buf, sizeof(buf), f)) != NULL)
    {
	for (i=strlen(bp)-1; i < 60; i++)
	    bp[i] = ' ';		/* pad it */
	bp[60] = 0;			/* trim it */
	if (linecnt >= nlines)
	    break;
	lines[linecnt++] = strdup(bp);
    }
				/* \x18 is uparrow, \x19 is downarrow */
    scroll_menu(lines, title, "Use \x18 \x19 PgUp PgDn; press ESC to exit", 
		5, 10, 17, 0);
    while (linecnt--)
	free(lines[linecnt]);
    free(lines);
}

/**** m a i n ****
    Abstract:	The main driver for HLBENCH.
    Parameters: The usual.
    Returns:	Errorlevel 0.
****************************/
int main(argc, argv)
int argc;
char *argv[];
{
    int sel = 0;
    int retval;
    int i;
    int analyzer = 0;
    int run_all = 0;
    char cmdbuf[32];
    char *fname = NULL;
    char *secname = NULL;
    WINDOW *w = NULL, *wbase;
    
    for (i=1; i<argc; i++)		/* process all arguments */
    {
	if (argv[i][0] == '-')		/* switches */
	{
	    switch(argv[i][1]) {
	    case '?':
		usage();
		break;
	    default:
		printf("Invalid argument '%s'\n", argv[i]);
		usage();
		break;
	    }
	}
	else				/* just text */
	{
	    if (fname == NULL)
		fname = argv[i];
	    else if (secname == NULL)
		secname = argv[i];
	    else
	    {	 
		printf("Too many filenames specified!\n");
		usage();
	    }
	}
    }
    if (fname == NULL)
    {	 
	fname = "CURRENT.TIM";
	unlink(fname);
    }
    if (secname == NULL)
    {
	FILE *f;
	char buf[20];
	if ((f = fopen("XREF.TXT", "r")) == NULL)
	{
	    strcpy(buf, "IBMAT339.TIM");
	    if ((f = fopen("XREF.TXT", "w")) != NULL)
	    {
		fprintf(f, "%s\n", buf);
		fclose(f);
	    }
	}
	else
	{    
	    fgets(buf, sizeof(buf), f);
	    buf[strlen(buf)-1] = 0;
	    fclose(f);
	}
	secname = strdup(buf);
    }
    
    for (i=0; i<hbound(prog); i++)		/* find analyzer */
    {	 
	if (prog[i].status & S_ANALYZE)
	    analyzer = i;
	if (prog[i].status & S_RUN_ALL)
	    run_all = i;
    }
    
    wbase = open_window(1, 1, 25, 80, 7);
    
    /* display startup screen */
    if ((retval = spawnlp(P_WAIT, "hlstart", "hlstart", NULL)) == 1)
    {
	text_display("hlstart.sct");
	if (xgetch() == ESC)
	{
	    close_window(wbase);
	    return(0);
	}
    }
    else if (retval == 2)
    {
	close_window(wbase);
	return(0);
    }

    text_display("HLBENCH.SCT");
    sel = run_all;
    while ((sel = do_menu(menu, "Benchmark Main Menu", 
	"Press Enter to select, ESC to return", sel)) != -1)
    {
	if (prog[sel].status & S_EXECUTABLE)
	{
	    if (!(prog[sel].status & (S_ANALYZE | S_DESCR)))
		w = open_window(1, 1, 25, 80, 7);
	    
	    sprintf(cmdbuf, prog[sel].options, fname, secname);
	    retval = spawnlp(P_WAIT, prog[sel].program,
			prog[sel].program, cmdbuf, "-B", NULL);
	    
	    if (w != NULL)		/* if we opened the window */
	    {	 
		close_window(w);
		w = NULL;
	    }
	    
	    if (retval != -1)
	    {
		if (prog[sel].status & S_SHOW_RESULTS)
		{
		    sprintf(cmdbuf, "-P%d -F%s -S%s", sel+1, fname, secname);
		    retval = spawnlp(P_WAIT, prog[analyzer].program,
			prog[analyzer].program, cmdbuf, NULL);
		}
	    }
	    else
	    {
		char buf[80];
		
		strcpy(buf, sys_errlist[errno]);
		strcat(buf, " -- couldn't run program.");
		pop_error(buf);
	    }
	}
	else if (prog[sel].status & S_HELP)	/* display help file */
	{    
	    help("hlhelp.txt", 500, "About these benchmarks");
	}
	else if (prog[sel].status & S_RENAME)	/* rename data file */
	{   
	    if (stricmp(fname, "CURRENT.TIM") == 0)
		cmdbuf[0] = 0;
	    else
		strcpy(cmdbuf, fname);
	    
	    w = open_window(11, 22, 13, 58, 7);
	    _settextposition(12, 23);
	    _outtext("Enter data file name: ");
	    for(;;)
	    {
		if (edit_line(cmdbuf, 12, 12, 46) == ESC)
		    break;
		else
		{
		    if (strchr(cmdbuf, '.') != NULL)	/* if extension */
			*(strchr(cmdbuf, '.')) = 0;	/* replace it */
		    strcat(cmdbuf, ".tim");
		    
		    if (rename(fname, cmdbuf))
		    {
			int c;
			
			if (errno == ENOENT)		/* no CURRENT yet */
			{
			    fname = strdup(cmdbuf);
			    break;
			}
		    
			c = pop_error("A file with that name exists -- use it anyway? (Y/N)");
			if ((c == 'Y') || (c == 'y'))
			{
			    if (unlink(cmdbuf))
			    {
				pop_error("Can't delete the existing file.  Try another name.");
				continue;		/* try again */
			    }
			    if (rename(fname, cmdbuf))
			    {
				pop_error("Can't use that name.  Try another one.");
				continue;		/* try again */
			    }
			    else
			    {
				fname = strdup(cmdbuf);
				break;			/* rename complete */
			    }
			}
			continue;			/* try again */
		    }
		    fname = strdup(cmdbuf);
		    break;				/* rename worked */
		}
	    }
	    close_window(w);
	    w = NULL;
	}
	else if (prog[sel].status & S_QUIT)	/* Die */
	{
	    close_window(wbase);
	    return(0);
	}
	else if (prog[sel].status & S_RUN_ALL)
	{
	    w = open_window(1, 1, 25, 80, 7);
	    for (i=0; i<hbound(prog); i++)
	    {
		if (prog[i].status & S_GROUP_TEST)
		{
		    sprintf(cmdbuf, prog[i].options, fname, secname);
		    retval = spawnlp(P_WAIT, prog[i].program,
			prog[i].program, cmdbuf, "-A", NULL);
		}
	    }
	    close_window(w);
	    w = NULL;
	    sel = analyzer;
	}
    }
    close_window(wbase);
    return(0);
}
