        name    itoa
        title   ITOA - integer to ASCII
        page    55,132

;
; ITOA.ASM --- Convert 16-bit integer to ASCII
;
; Copyright (c) 1987 Ziff Communications Co.
; Ray Duncan
;
; Call with:    AX    = 16-bit integer
;               DS:SI = buffer to receive string,
;                       must be at least 6 bytes long
;               CX    = radix
;
; Returns:      DS:SI = address of converted string
;               AX    = length of string
; 
; Since test for value = zero is made after a digit
; has been stored, the resulting string will always
; contain at least one significant digit.

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT

        public  itoa            ; make ITOA available to Linker

itoa    proc    near            ; convert long int to ASCII.

        add     si,6            ; advance to end of buffer
        push    si              ; and save that address.
        or      ax,ax           ; test sign of 16-bit value,
        pushf                   ; and save sign on stack.
        jns     itoa1           ; jump if value was positive.
        neg     ax              ; find absolute value.

itoa1:  cwd                     ; divide value by radix to extract
        div     cx              ; next digit for forming string.

        add     dl,'0'          ; convert remainder to ASCII digit
        cmp     dl,'9'          ; in case converting to hex ASCII,
        jle     itoa2           ; jump if in range 0-9,
        add     dl,'A'-'9'-1    ; correct digit if in range A-F.

itoa2:  dec     si              ; back up through buffer
        mov     [si],dl         ; store this character into string.
        or      ax,ax
        jnz     itoa1           ; no, convert another digit.

        popf                    ; was original value negative?
        jns     itoa3           ; no, jump

        dec     si              ; yes,store sign into output string.
        mov     byte ptr [si],'-'

itoa3:  pop     ax              ; calculate length of string
        sub     ax,si
        ret                     ; back to caller.

itoa    endp

_TEXT   ends

        end
