

(****************************************************************)
(*								*)
(*	       MS-DOS FUNCTION CALL SUPPORT ROUTINES		*)
(*			 for SURPAS-86 1.0			*)
(*								*)
(*			Copyright 1987     			*)
(*		         Tixaku Pty Ltd         		*)
(*								*)
(****************************************************************)


(* This include file contains a number of subroutines which may	*)
(* be used to access various MS-DOS functions not directly sup-	*)
(* ported by SURPAS Pascal. To use the procedures in this file,	*)
(* either include the entire file in the compilation of your	*)
(* program, or copy the type and variable declarations plus the	*)
(* procedures you need into your source text. Note that some of	*)
(* the routines require MS-DOS version 2.0 or later. Don't at-	*)
(* tempt to use these under pre-2.0 versions.			*)

(*$R- Turn off range checking.					*)

TYPE

(* Register pack type used in software interrupts.		*)

  REGPACK = RECORD
	      AX,BX,CX,DX,BP,SI,DI,DS,ES,FLAGS: INTEGER;
            END;

(* File name type used by INITDIR and READDIR routines.		*)

  FILENAME = STRING[11];

(* Unopened FCB type used by INITDIR and READDIR routines.	*)

  UNOFCB = RECORD
	     DRV: BYTE;
	     NAM: ARRAY[1..11] OF CHAR;
	   END;

(* Sector buffer type used by DIR routines.			*)

  SECTOR = ARRAY[0..127] OF BYTE;

(* Path string type.						*)

  PATHSTR = STRING[63];

VAR

(* Register pack variable used in software interrupts.		*)

  REGS: REGPACK;

(* Unopened FCB used by INITDIR and READDIR routines.		*)

  UFCB: UNOFCB AT CSEG:$5C;

(* Sector buffer used by INITDIR and READDIR routines.		*)

  SBUF: SECTOR AT CSEG:$80;

(* End-of-directory flag set by INITDIR and READDIR routines.	*)

  EOFDIR: BOOLEAN;

(* INITDIR initializes a directory read operation. DRIVE speci-	*)
(* fies the drive number (0=default, 1=A:, 2=B:, etc.) and FNAM	*)
(* specifies the search file name. The search file name must be	*)
(* exactly 11 characters long (name is first 8 characters, type	*)
(* is last 3 characters) and it may contains ? wild cards to	*)
(* match any character in that position. Following a call to	*)
(* INITDIR, the EOFDIR variable is TRUE if the directory is	*)
(* empty, otherwise FALSE. The file names may be read using the	*)
(* READDIR routine below.					*)

PROCEDURE INITDIR(DRIVE: INTEGER; FNAM: FILENAME);
BEGIN
  REGS.AX:=$1A00; REGS.DX:=OFS(SBUF); REGS.DS:=SEG(SBUF);
  SWINT($21,REGS);
  UFCB.DRV:=DRIVE; MOVE(FNAM[1],UFCB.NAM,11);
  REGS.AX:=$1100; REGS.DX:=OFS(UFCB); REGS.DS:=SEG(UFCB);
  SWINT($21,REGS); EOFDIR:=LO(REGS.AX)<>0;
END;

(* READDIR reads the next directory entry. INITDIR must be cal-	*)
(* led before READDIR to establish the search file name. FNAM	*)
(* returns the next file name (of length 11) or an empty string	*)
(* if EOFDIR is	TRUE. Use a $V- compiler directive if the FNAM	*)
(* parameter is not of type STRING[11].				*)

PROCEDURE READDIR(VAR FNAM: FILENAME);
BEGIN
  IF EOFDIR THEN FNAM:='' ELSE
  BEGIN
    MOVE(SBUF[1],FNAM[1],11); FNAM[0]:=@11;
    REGS.AX:=$1A00; REGS.DX:=OFS(SBUF); REGS.DS:=SEG(SBUF);
    SWINT($21,REGS);
    REGS.AX:=$1200; REGS.DX:=OFS(UFCB); REGS.DS:=SEG(UFCB);
    SWINT($21,REGS); EOFDIR:=LO(REGS.AX)<>0;
  END;
END;

(* GETDISK returns the currently selected drive (0=A:, 1=B:,    *)
(* etc.).                                                       *)

PROCEDURE GETDISK(VAR DRIVE: INTEGER);
BEGIN
  REGS.AX:=$1900; SWINT($21,REGS); DRIVE:=LO(REGS.AX);
END;

(* SETDISK changes the default disk to the drive specified in   *)
(* DRIVE (0=A:, 1=B:, etc.).                                    *)

PROCEDURE SETDISK(DRIVE: INTEGER);
BEGIN
  REGS.AX:=$0E00; REGS.DX:=DRIVE; SWINT($21,REGS);
END;

(* GETDATE returns the current date set in the operating sys-	*)
(* tem. Ranges of the values returned are: YEAR 1980-2099,	*)
(* MONTH 1-12, DAY 1-31 and DOFW (day of week) 0-6 with 0 cor-	*)
(* responding to sunday, 1 to monday, etc.).			*)

PROCEDURE GETDATE(VAR YEAR,MONTH,DAY,DOFW: INTEGER);
BEGIN
  REGS.AX:=$2A00; SWINT($21,REGS);
  YEAR:=REGS.CX; MONTH:=HI(REGS.DX);
  DAY:=LO(REGS.DX); DOFW:=LO(REGS.AX);
END;

(* SETDATE sets the current date in the operating system. Valid	*)
(* parameter ranges are: YEAR 1980-2099, MONTH 1-12 and DAY 1-	*)
(* 31. If the date is not valid, the function call is ignored.	*)

PROCEDURE SETDATE(YEAR,MONTH,DAY: INTEGER);
BEGIN
  REGS.AX:=$2B00; REGS.CX:=YEAR;
  REGS.DX:=SWAP(MONTH)+DAY; SWINT($21,REGS);
END;

(* GETTIME returns the current time set in the operating sys-	*)
(* tem. Ranges of the values returned are: HOUR 0-23, MINUTE	*)
(* 0-59, SECOND 0-59 and SEC100 (hundredths of seconds) 0-99.	*)

PROCEDURE GETTIME(VAR HOUR,MINUTE,SECOND,SEC100: INTEGER);
BEGIN
  REGS.AX:=$2C00; SWINT($21,REGS);
  HOUR:=HI(REGS.CX); MINUTE:=LO(REGS.CX);
  SECOND:=HI(REGS.DX); SEC100:=LO(REGS.DX);
END;

(* SETTIME sets the time in the operating system. Valid parame-	*)
(* ter ranges are: HOUR 0-23, MINUTE 0-59, SECOND 0-59 and	*)
(* SEC100 (hundredths of seconds) 0-99. If the time is not va-	*)
(* lid, the function call is ignored.				*)

PROCEDURE SETTIME(HOUR,MINUTE,SECOND,SEC100: INTEGER);
BEGIN
  REGS.AX:=$2D00; REGS.CX:=SWAP(HOUR)+MINUTE;
  REGS.DX:=SWAP(SECOND)+SEC100; SWINT($21,REGS);
END;

(* GETDOSVER returns the MS-DOS version number. For version	*)
(* 1.28 the MAJOR number would be 1 and the MINOR number 28.	*)
(* For pre-1.28, MAJOR returns 0. Note that version 1.1 is the	*)
(* same as 1.10, not 1.01.					*)

PROCEDURE GETDOSVER(VAR MAJOR,MINOR: INTEGER);
BEGIN
  REGS.AX:=$3000; SWINT($21,REGS);
  MAJOR:=LO(REGS.AX); MINOR:=HI(REGS.AX);
END;

(* DISKFREE returns the free space on disk along with other	*)
(* additional information about the disk. DRIVE specifies the	*)
(* drive number (0=default, 1=A:, 2=B:, etc.). CLA is number of	*)
(* clusters available, CPD is clusters per drive, BPS is bytes	*)
(* per sector and SPC is sectors per cluster. The total number	*)
(* of bytes per disk is (CPD+0.0)*BPS*SPC. The number of bytes	*)
(* free	is (CLA+0.0)*BPS*SPC. Real zero (0.0) must be added to	*)
(* convert the type of the expression to real as an overflow	*)
(* would otherwise occur. SPC returns -1 if the drive number is	*)
(* invalid. This function is only available in MS-DOS 2.0 or	*)
(* later.							*)

PROCEDURE DISKFREE(DRIVE: INTEGER; VAR CLA,CPD,BPS,SPC: INTEGER);
BEGIN
  REGS.AX:=$3600; REGS.DX:=DRIVE; SWINT($21,REGS);
  CLA:=REGS.BX; CPD:=REGS.DX; BPS:=REGS.CX; SPC:=REGS.AX;
END;

(* CREATEDIR creates a sub-directory. PATH must be a valid path	*)
(* name. STATUS returns the status of the operation. 0 means no	*)
(* error, 3 indicates an invalid path name, and 5 indicates	*)
(* that there is no room in the parent directory or that a 	*)
(* file/directory of that name already exists. This function is	*)
(* only available in MS-DOS 2.0 or later.			*)

PROCEDURE CREATEDIR(PATH: PATHSTR; VAR STATUS: INTEGER);
VAR
  N: INTEGER;
BEGIN
  N:=LEN(PATH); MOVE(PATH[1],PATH[0],N); PATH[N]:=@0;
  REGS.AX:=$3900; REGS.DX:=OFS(PATH); REGS.DS:=SEG(PATH);
  SWINT($21,REGS);
  IF REGS.FLAGS AND 1=0 THEN STATUS:=0 ELSE STATUS:=REGS.AX;
END;

(* REMOVEDIR removes a sub-directory from its parent directory.	*)
(* PATH must be a valid path name. STATUS returns the status of	*)
(* the operation. 0 means no error, 3 indicates	an invalid path	*)
(* name, 5 indicates that the path is not empty, not a directo-	*)
(* ry, the root directory or corrupted, and 16 indicates that	*)
(* the path specified is the current directory on a drive. This	*)
(* function is only available in MS-DOS 2.0 or later.		*)

PROCEDURE REMOVEDIR(PATH: PATHSTR; VAR STATUS: INTEGER);
VAR
  N: INTEGER;
BEGIN
  N:=LEN(PATH); MOVE(PATH[1],PATH[0],N); PATH[N]:=@0;
  REGS.AX:=$3A00; REGS.DX:=OFS(PATH); REGS.DS:=SEG(PATH);
  SWINT($21,REGS);
  IF REGS.FLAGS AND 1=0 THEN STATUS:=0 ELSE STATUS:=REGS.AX;
END;

(* SETDIR changes the current directory to the path name speci-	*)
(* fied in the PATH parameter. STATUS returns the status of the	*)
(* operation. 0 means no error and 3 indicates that the path	*)
(* does not exist. This function is only available in MS-DOS	*)
(* 2.0 or later.						*)

PROCEDURE SETDIR(PATH: PATHSTR; VAR STATUS: INTEGER);
VAR
  N: INTEGER;
BEGIN
  N:=LEN(PATH); MOVE(PATH[1],PATH[0],N); PATH[N]:=@0;
  REGS.AX:=$3B00; REGS.DX:=OFS(PATH); REGS.DS:=SEG(PATH);
  SWINT($21,REGS);
  IF REGS.FLAGS AND 1=0 THEN STATUS:=0 ELSE STATUS:=REGS.AX;
END;

(* GETDIR returns the path name of the current directory on the	*)
(* drive specified (0=default, 1=A:, 2=B:, etc.). The path does	*)
(* not include the drive specifier or leading path separator.	*)
(* STATUS returns the status of the operation. 0 means no error	*)
(* and 15 indicates an invalid drive number. Use a $V- compiler	*)
(* directive if the PATH parameter is not of type STRING[63].	*)
(* This function is only available in MS-DOS 2.0 or later.	*)

PROCEDURE GETDIR(DRIVE: INTEGER;
  VAR PATH: PATHSTR; VAR STATUS: INTEGER);
VAR
  N: INTEGER;
BEGIN
  REGS.AX:=$4700; REGS.DX:=DRIVE; REGS.SI:=OFS(PATH);
  REGS.DS:=SEG(PATH); SWINT($21,REGS);
  IF REGS.FLAGS AND 1=0 THEN
  BEGIN
    N:=0; WHILE PATH[N]<>@0 DO N:=N+1;
    MOVE(PATH[0],PATH[1],N); PATH[0]:=CHR(N);
    STATUS:=0;
  END ELSE
  STATUS:=REGS.AX;
END;

(* RENFILE attempts to rename the file designated by OPATH into	*)
(* the path designated by NPATH. STATUS returns the status of	*)
(* the operation. 0 means no error, 2 indicates that the file	*)
(* named by OPATH does not exist, 5 indicates that the path	*)
(* specified in OPATH is a directory or that the file specified	*)
(* by NPATH already exists or that there is no room to create a	*)
(* new directory entry, and 17 indicates that OPATH and NPATH	*)
(* are not on the same drive. This function is only available	*)
(* in MS-DOS 2.0 or later.					*)

PROCEDURE RENFILE(OPATH,NPATH: PATHSTR; VAR STATUS: INTEGER);
VAR
  N: INTEGER;
BEGIN
  N:=LEN(OPATH); MOVE(OPATH[1],OPATH[0],N); OPATH[N]:=@0;
  N:=LEN(NPATH); MOVE(NPATH[1],NPATH[0],N); NPATH[N]:=@0;
  REGS.AX:=$5600; REGS.DX:=OFS(OPATH); REGS.DI:=OFS(NPATH);
  REGS.DS:=SEG(OPATH); REGS.ES:=SEG(NPATH); SWINT($21,REGS);
  IF REGS.FLAGS AND 1=0 THEN STATUS:=0 ELSE STATUS:=REGS.AX;
END;
