/* COMMON IPC ACCESS STRUCTURE */
struct ipc_perm {
	ushort uid;	/* owner user identifier */
	ushort gid;	/* owner group identifier */
	ushort cuid;	/* creator user identifier */
	ushort cgid;	/* creator group identifier */
	ushort mode;	/* access code */
	ushort seq;	/* slot usage sequence number */
	key_t  key;	/* key */
		};
/* COMMON IPC DEFINITIONS */
/* MODE BITS  */
#define IPC_ALLOC	0100000		/* entry selected */
#define IPC_CREAT	0001000		/* create entry if no key exists */
#define IPC_EXCL	0002000		/* terminate with error if key exists */
#define IPC_NOWAIT	0004000		/* terminate with error if resource
						waiting is required */
/* KEYS */
#define IPC_RMID	0	/* delete identifier */
#define IPC_SET		1	/* set WSET options */
#define IPC_STAT	2	/* get options */