#include "allwind.h"

#ifdef ISWIN31
HMIDIOUT hMidiOut = 0;
#endif

NODE *lsound(NODE *arg)
   {
   int duration;
   int hertz;
   int frac;
   int i;
   int odd;
   
   NODE *args;
   
   long frequency;
   
   /* open sound and get arg list */
   
   OpenSound();
   
   args = car(arg);
   
   /* must be a list that contains something */
   
   if (is_list(args) && (args != NIL))
      {
      
      /* count items in list and check that they are pairs */
      
      arg = args;
      i=0;
      odd=0;
      
      while (arg != NIL)
         {
         if (arg != NIL) arg=cdr(arg);
         if (arg != NIL) arg=cdr(arg); else odd = 1;
         i++;
         }
      
      /* if sound creation ok and we have pairs continue */
      
      if (!SetVoiceQueueSize(1,i*6) && (!odd))
         {
         
         arg = args;
         
         /* fill queue with freq/duration pairs */
         
         while (arg != NIL)
            {
            hertz = int_arg(arg);
            if (cdr(arg) != NIL) duration = int_arg(arg=cdr(arg));
            frequency = hertz*0x10000L;
            SetVoiceSound(1, frequency, duration);
            if (arg != NIL) arg=cdr(arg);
            }
         
         /* play it */
         
         StartSound();
         WaitSoundState(S_QUEUEEMPTY);
         StopSound();           
         CloseSound();
         }
      else
         {
         MessageBox(MainHWindow, "Too long or Not paired", "Sound Error", MB_OK | MB_ICONEXCLAMATION);
         }
      }
   else
      {
      MessageBox(MainHWindow, "Bad argument", "Sound Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
   return (UNBOUND);
   }

NODE *lmidiopen(NODE *args)
   {
#ifdef ISWIN31
   
   UINT id;
   UINT MidiError;
   
   MIDIOUTCAPS moc;
   
   NODE *targ;
   NODE *val = UNBOUND;
   
   char MidiErrorBuffer[MAX_BUFFER_SIZE];
   
   /* if not open open it */
   
   if (!hMidiOut)
      {
      
      id = MIDIMAPPER;
      
      if (args != NIL)
         {
         id = int_arg(args);
         if (id > midiOutGetNumDevs())
            {
            MessageBox(MainHWindow, "Invalid Midi device", "Midi Error", MB_OK | MB_ICONEXCLAMATION);
            }
         }
      
      MidiError = midiOutGetDevCaps(id, &moc, sizeof(moc));
      
      if (!MidiError) MidiError = midiOutOpen(&hMidiOut, id, NULL, 0L, 0L);
      
      if (MidiError) 
         {
         midiOutGetErrorText(MidiError, MidiErrorBuffer, MAX_BUFFER_SIZE);
         MessageBox(MainHWindow, MidiErrorBuffer, "Midi Error", MB_OK | MB_ICONEXCLAMATION);
         }
      else
         {
	 targ = make_strnode(moc.szPname, NULL, strlen(moc.szPname), STRING, strnzcpy);
         val = parser(targ, FALSE);
         return(val);
         }
      }
   else
      {
      MessageBox(MainHWindow, "Already Open", "Midi Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
#else
   MessageBox(MainHWindow, "Only supported on Windows 3.1", "Sorry", MB_OK);
#endif
   
   return (UNBOUND);
   }

NODE *lmidiclose(NODE *args)
   {
#ifdef ISWIN31
   
   UINT MidiError;
   char MidiErrorBuffer[MAX_BUFFER_SIZE];
   
   /* if open close it */
   
   if (hMidiOut)
      {
      
      MidiError = midiOutClose(hMidiOut);
      
      hMidiOut = 0;
      
      if (MidiError) 
         {
         midiOutGetErrorText(MidiError, MidiErrorBuffer, MAX_BUFFER_SIZE);
         MessageBox(MainHWindow, MidiErrorBuffer, "Midi Error", MB_OK | MB_ICONEXCLAMATION);
         }
      }
   else
      {
      MessageBox(MainHWindow, "Already closed", "Midi Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
#else
   MessageBox(MainHWindow, "Only supported on Windows 3.1", "Sorry", MB_OK);
#endif
   
   return (UNBOUND);
   }

NODE *lmidimessage(NODE *arg)
   {
#ifdef ISWIN31
   
   NODE *args;
   UINT MidiError;
   char MidiErrorBuffer[MAX_BUFFER_SIZE];
   
   int byte0;
   int byte1;
   int byte2;
   int i;
   int j;
   
   union
      {
      long mylong;
      char mybyte[4];
      } bytetolong;
   
   MIDIHDR *MidiOutHdr;
   BYTE *MidiOutData;
   
   HANDLE DataHandle;  
   HANDLE HdrHandle;  
   
   /* if midi open continue */
   
   if (hMidiOut)
      {
      args = car(arg);
      
      /* if a list with something in it continue */
      
      if (is_list(args) && (args != NIL))
         {
         
         /* if not system exclusive then use shortmsg else use longmsg */
         
         if (int_arg(args) != 0xF0)
            {
            
            /* pack 3 bytes at a time and send them as short messages */
            
            arg = args;
            
            while (arg != NIL)
               {
               bytetolong.mylong = 0L;
               bytetolong.mybyte[0] = int_arg(arg);
               if (cdr(arg) != NIL) bytetolong.mybyte[1] = int_arg(arg=cdr(arg));
               if (cdr(arg) != NIL) bytetolong.mybyte[2] = int_arg(arg=cdr(arg));
               MidiError = midiOutShortMsg(hMidiOut, bytetolong.mylong);
               if (MidiError) break;
               if (arg != NIL) arg=cdr(arg);
               }
            
            }
         else
            {
            
            /* count elements in list so we can allocate buffer */
            
            i=0;
            arg = args;
            
            while (arg != NIL)
               {
               arg=cdr(arg);
               i++;
               }
            
            /* allocate structure buffer */
            
            HdrHandle = (HANDLE)GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE | GMEM_ZEROINIT, sizeof(MIDIHDR));
            MidiOutHdr = (MIDIHDR *)GlobalLock((HGLOBAL)HdrHandle);
            
            DataHandle = (HANDLE)GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE | GMEM_ZEROINIT, i);
            MidiOutData = (BYTE *)GlobalLock((HGLOBAL)DataHandle);
            
            /* pack the buffer array and set size */
            
            arg = args;
            
            for (j=0;j<i;j++)
               {
               MidiOutData[j] = int_arg(arg);
               arg=cdr(arg);
               }
            
            MidiOutHdr->dwBufferLength = i;
            
            MidiOutHdr->lpData = MidiOutData;
            
            /* prepare it, send it out, and unprepare it */
            
            MidiError = midiOutPrepareHeader(hMidiOut, MidiOutHdr, sizeof(MIDIHDR));
            if (!MidiError) MidiError = midiOutLongMsg(hMidiOut, MidiOutHdr, sizeof(MIDIHDR));
            if (!MidiError) MidiError = midiOutUnprepareHeader(hMidiOut, MidiOutHdr, sizeof(MIDIHDR));
            
            /* free buffer and struct */
            
            GlobalUnlock(DataHandle);
            GlobalFree(DataHandle);
            
            GlobalUnlock(HdrHandle);
            GlobalFree(HdrHandle);
            }
         
         /* if midi error let 'em know */
         
         if (MidiError) 
            {
            midiOutGetErrorText(MidiError, MidiErrorBuffer, MAX_BUFFER_SIZE);
            MessageBox(MainHWindow, MidiErrorBuffer, "Midi Error", MB_OK | MB_ICONEXCLAMATION);
            }
         }
      else
         {
         MessageBox(MainHWindow, "Bad argument", "Midi Error", MB_OK | MB_ICONEXCLAMATION);
         }
      }
   else
      {
      MessageBox(MainHWindow, "Not Open", "Midi Error", MB_OK | MB_ICONEXCLAMATION);
      }
   
#else
   MessageBox(MainHWindow, "Only supported on Windows 3.1", "Sorry", MB_OK);
#endif
   
   return (UNBOUND);
   }

NODE *lmci(NODE *args)
   {
#ifdef ISWIN31
   
   NODE *targ;
   NODE *val = UNBOUND;
   
   DWORD MciError;
   
   char textbuf[MAX_BUFFER_SIZE];
   char MciReturnBuffer[MAX_BUFFER_SIZE];
   char MciErrorBuffer[MAX_BUFFER_SIZE];
   char callback[MAX_BUFFER_SIZE];
   
   /* get mci command string */
   
   cnv_strnode_string(textbuf,args);
   
   /* check for optional callback routine */
   
   if (cdr(args) != NIL)
      {
      cnv_strnode_string(callback, cdr(args));
      strcpy(mci_callback,callback);
      }
   
   MciReturnBuffer[0] = '\0';
   
   /* send out command */
   
   MciError = mciSendString(textbuf, MciReturnBuffer, MAX_BUFFER_SIZE, MainHWindow);
   
   /* if error let user know else continue */
   
   if (MciError) 
      {
      mciGetErrorString(MciError, MciErrorBuffer, MAX_BUFFER_SIZE);
      MessageBox(MainHWindow, MciErrorBuffer, "MCI Error", MB_OK | MB_ICONEXCLAMATION);
      }
   else
      {
      
      /* if something was returned then return it to user */
      
      if (strlen(MciReturnBuffer))
         {
         targ = make_strnode(MciReturnBuffer, NULL, strlen(MciReturnBuffer), STRING, strnzcpy);
         val = parser(targ, FALSE);
         return(val);
         }  
      }
#else
   MessageBox(MainHWindow, "Only supported on Windows 3.1", "Sorry", MB_OK);
#endif
   
   return (UNBOUND);
   }

NODE *lsettimer(NODE *args)
   {
   char callback[MAX_BUFFER_SIZE];
   WORD delay;
   int id;   
   
   // get id and if valid continue
   
   id = int_arg(args);
   
   if ((id > 0) && (id < 32))
      {
      
      // get delay callback
      
      delay = int_arg(args=cdr(args));
      
      cnv_strnode_string(callback, args=cdr(args));
      
      if (timer_callback[id] == NULL) timer_callback[id] = (char *)malloc(MAX_BUFFER_SIZE);
      strcpy(timer_callback[id],callback);
      
      // if not set sucessfully error
      
      if (!SetTimer(MainHWindow, id, delay, NULL))
         {
         MessageBox(MainHWindow, "Too Many Timers", "Error", MB_ICONEXCLAMATION | MB_OK);
         }
      }
   else
      {
      MessageBox(MainHWindow, "Bad Timer Id", "Error", MB_ICONEXCLAMATION | MB_OK);
      }   
   return (UNBOUND);
   }

NODE *lcleartimer(NODE *args)
   {
   int id;   
   
   // get args
   
   id = int_arg(args);
   
   // if timer was not set let user know
   
   if (!KillTimer(MainHWindow, id))
   MessageBox(MainHWindow, "Timer not found", "Error", MB_ICONEXCLAMATION | MB_OK);
   
   return (UNBOUND);
   }
