/****************************************************************************
Module name: SetupInf.C
Programmer : Jeffrey M. Richter.
*****************************************************************************/

#include <windows.h>
#include <string.h>
#include <stdlib.h>
#include "Setup.H"
#include "SetupInf.H"


SETUPINFO _SetupInfo;   // The global Setup Information

#define MAXSETUPINFOSIZE   20480
#define MAXAPPDESC         50
#define MAXPARSELINELEN    100

#define ARRAY_LEN(Array)   (sizeof(Array) / sizeof(Array[0]))



static WORD NEAR latoi (LPSTR szString) {
   WORD wNum = 0;
   while (*szString >= '0' && *szString <= '9')
      wNum = (wNum * 10) + (*szString++ - '0');
   return(wNum);
}

static LPSTR NEAR StripEndBlanks (LPSTR szString) {
   LPSTR p = szString, q = szString;

   while (*p == ' ' || *p == '\t') p++;
   while (*p) *szString++ = *p++;
   *szString-- = 0; 
   while (szString >= q && (*szString == ' ' || *szString == '\t'))
      *szString-- = 0;
   return(q);
}

//***************************************************************************

class DISKINFO {
   UINT uNum;
   char szDesc[MAXDISKDESC];
   public:
   DISKINFO (LPSTR szLine);
   void GetDesc (LPSTR szDesc) const
      { lstrcpy(szDesc, this->szDesc); }

   UINT GetNum (void) const { return(uNum); }
};

DISKINFO::DISKINFO (LPSTR szLine) {
   LPSTR szData; 
   if ((szData = _fstrchr(szLine, '=')) != NULL) *szData++ = 0;
   uNum = latoi(szLine);
   lstrcpy(szDesc, szData);
}

//***************************************************************************

class DIRINFO {
   UINT uNum;
   char szPath[_MAX_PATH];
   public:
   DIRINFO (LPSTR szLine);
   void GetPath (LPSTR szPath) const
      { lstrcpy(szPath, this->szPath); }
   UINT GetNum (void) const { return(uNum); }
};

DIRINFO::DIRINFO (LPSTR szLine) {
   LPSTR szData;
   if ((szData = _fstrchr(szLine, '=')) != NULL) *szData++ = 0;
   uNum = latoi(szLine);
   lstrcpy(szPath, szData);
}

//***************************************************************************

class FILEINFO {
   char szDesc[MAXDIRDESC];
   UINT uSrcDiskette;
   UINT uSrcDir;
   char szSrcName[MAXFILENAME];
   UINT uDstDir;
   char szDstName[MAXFILENAME];
   BOOL fSharable;
   char szDstDir[_MAX_PATH];  // Where file was installed
   public:
   FILEINFO (LPSTR szLine);

   UINT GetSrcDiskNum (void) const
      { return(uSrcDiskette); }

   UINT GetSrcDirNum (void) const
      { return(uSrcDir); }

   UINT GetDstDirNum (void) const
      { return(uDstDir); }

   BOOL GetFileInfo (LPSTR szDesc, LPSTR szSrcFileName, LPSTR szDstFileName) const {
      lstrcpy(szDesc, this->szDesc);
      lstrcpy(szSrcFileName, szSrcName);
      lstrcpy(szDstFileName, szDstName);
      return(fSharable);
   }

   BOOL DoesDstFileNameMatch (LPCSTR szDstFileName) const
      { return(lstrcmpi(szDstFileName, szDstName) == 0); }

   void SetDstDir (LPCSTR szDstDir)
      { lstrcpy(this->szDstDir, szDstDir); }

   void GetDstDir (LPSTR szDstDir) const
      { lstrcpy(szDstDir, this->szDstDir); }

};

FILEINFO::FILEINFO (LPSTR szLine) {
   LPSTR p = _fstrchr(szLine, ','), q;
   *p++ = 0;
   lstrcpy(szDesc, szLine);
   uSrcDiskette = latoi(StripEndBlanks(p));
   uSrcDir = latoi(p = StripEndBlanks(_fstrchr(p, '-') + 1));
   p = StripEndBlanks(_fstrchr(p, ':') + 1);
   q = _fstrchr(p, ','); *q = 0;
   lstrcpy(szSrcName, p);
   p = StripEndBlanks(p = q + 1);   // Point to 1st char of DstName
   uDstDir = latoi(p);
   p = StripEndBlanks(p = _fstrchr(p, ':') + 1);
   q = _fstrchr(p, ','); *q = 0;
   lstrcpy(szDstName, p);
   p = StripEndBlanks(p = q + 1);   // Point to 1st char of Sharable
   fSharable = ((*p == 'Y') || (*p == 'y'));
   szDstDir[0] = 0;
}

//***************************************************************************

class PMINFO {
   char szDstFileName[MAXFILENAME];
   char szAppDesc[MAXAPPDESC];
   UINT uIconNum;
   public:
   PMINFO (LPSTR szLine);
   UINT GetPMItemInfo (LPSTR szAppDesc, LPSTR szDstFileName) const;
};

PMINFO::PMINFO (LPSTR szLine) {
   LPSTR p = _fstrchr(szLine, ','), q;
   *p++ = 0;
   lstrcpy(szDstFileName, szLine);
   p = StripEndBlanks(p);  // Point to 1st char of AppDesc
   lstrcpy(szAppDesc, p);
   q = _fstrchr(p, ',');
   if (q == NULL) uIconNum = 0;
   else {
      p = StripEndBlanks(q + 1); // Point to 1st char of Icon #
      uIconNum = latoi(p);
   }
}

UINT PMINFO::GetPMItemInfo (LPSTR szAppDesc, LPSTR szDstFileName) const {
   lstrcpy(szAppDesc, this->szAppDesc);
   lstrcpy(szDstFileName, this->szDstFileName);
   return(uIconNum);
}
//***************************************************************************

// -1 if an error occurs: file has no destination path (file wasn't installed)
UINT SETUPINFO::GetPMItemInfo (UINT uPMItemNum, LPSTR szAppDesc,
   LPSTR szDstFilePath) const {
   char szDstFileName[MAXFILENAME];

   UINT uIconNum =
      PMFiles[uPMItemNum]->GetPMItemInfo(szAppDesc, szDstFileName);
   // Find the destination file name in the file list
   for (UINT x = 0; x < uNumFiles; x++)
      if (Files[x]->DoesDstFileNameMatch(szDstFileName)) break;

   if (x == uNumFiles) return(-1);  // Error in SETUP.INF, file not found
   Files[x]->GetDstDir(szDstFilePath);
   if (szDstFilePath[0] == 0) return(-1);
   if (szDstFilePath[lstrlen(szDstFilePath) - 1] != '\\')
      lstrcat(szDstFilePath, "\\");
   lstrcat(szDstFilePath, szDstFileName);
   return(uIconNum);
}

void SETUPINFO::GetFileInstallInfo (UINT uFileNum,
   LPSTR szSrcDiskDesc, LPSTR szFileDesc,
   LPSTR szSrcFilePath, LPSTR szSrcFileName,
   LPSTR szDstFilePath, LPSTR szDstFileName, BOOL FAR *fSharable) const {

   FindDiskFromNum(Files[uFileNum]->GetSrcDiskNum())->GetDesc(szSrcDiskDesc);
   FindSrcDirFromNum(Files[uFileNum]->GetSrcDirNum())->GetPath(szSrcFilePath);
   FindDstDirFromNum(Files[uFileNum]->GetDstDirNum())->GetPath(szDstFilePath);
   *fSharable = Files[uFileNum]->
      GetFileInfo(szFileDesc, szSrcFileName, szDstFileName);
}


DISKINFO *SETUPINFO::FindDiskFromNum (UINT uNum) const {
   UINT x;
   for (x = 0; x < uNumDisks; x++)
      if (Disks[x]->GetNum() == uNum) return(Disks[x]);
   return(NULL);  
}

DIRINFO *SETUPINFO::FindSrcDirFromNum (UINT uNum) const {
   UINT x;
   for (x = 0; x < uNumSrcDirs; x++)
      if (SrcDirs[x]->GetNum() == uNum) return(SrcDirs[x]);
   return(NULL);  
}

DIRINFO *SETUPINFO::FindDstDirFromNum (UINT uNum) const {
   UINT x;
   for (x = 0; x < uNumDstDirs; x++)
      if (DstDirs[x]->GetNum() == uNum) return(DstDirs[x]);
   return(NULL);  
}

SETUPINFO::SETUPINFO (void) {
   ReadState = RS_UNDEFINED;
   szAppName[0] = 0;
   szDefaultDstDir[0] = 0;
   uSpaceNeeded = 0;
   szPMGrpFileName[0] = 0;
   szPMGrpName[0] = 0;
   fShowSubDirCreateStats = FALSE;

   uNumDisks = uNumSrcDirs = uNumDstDirs = uNumFiles = uNumPMFiles = 0;
   UINT x;
   for (x = 0; x < ARRAY_LEN(Disks);   x++) Disks[x]   = NULL;
   for (x = 0; x < ARRAY_LEN(SrcDirs); x++) SrcDirs[x] = NULL;
   for (x = 0; x < ARRAY_LEN(DstDirs); x++) DstDirs[x] = NULL;
   for (x = 0; x < ARRAY_LEN(Files);   x++) Files[x]   = NULL;
   for (x = 0; x < ARRAY_LEN(PMFiles); x++) PMFiles[x] = NULL;
}

SETUPINFO::~SETUPINFO (void) {
   ReadState = RS_UNDEFINED;
   szAppName[0] = 0;
   szDefaultDstDir[0] = 0;
   uSpaceNeeded = 0;
   szPMGrpFileName[0] = 0;
   szPMGrpName[0] = 0;
   fShowSubDirCreateStats = FALSE;

   UINT x;
   for (x = 0; x < uNumDisks; x++) delete Disks[x];
   for (x = 0; x < uNumSrcDirs; x++) delete SrcDirs[x];
   for (x = 0; x < uNumDstDirs; x++) delete DstDirs[x];
   for (x = 0; x < uNumFiles;   x++) delete Files[x];
   for (x = 0; x < uNumPMFiles; x++) delete PMFiles[x];
   uNumDisks = uNumSrcDirs = uNumDstDirs = uNumFiles = uNumPMFiles = 0;
}


void SETUPINFO::GetDstDir (UINT uDirNum, LPSTR szDstDir) const
   { DstDirs[uDirNum]->GetPath(szDstDir); }

void SETUPINFO::SetFileDstDir (UINT uFileNum, LPCSTR szDstDir) {
   Files[uFileNum]->SetDstDir(szDstDir);
}

SETUPINFO::ISIERROR SETUPINFO::InitSetupInfo (LPSTR szSetupInfoPathName) {
   HGLOBAL hGlbl;
   BOOL fOk;
   LPSTR p;

   hGlbl = GlobalAlloc(GMEM_MOVEABLE | GMEM_ZEROINIT, MAXSETUPINFOSIZE);
   if (hGlbl == NULL) return(ISI_NOMEM);

   OFSTRUCT of;
   HFILE hFile = OpenFile(szSetupInfoPathName, &of, OF_READ);
   if (hFile == -1) {
      GlobalFree(hGlbl);
      return(ISI_FILENOTFOUND);
   }
   p = GlobalLock(hGlbl);
   // Put a terminating zero byte at the end of the buffer.
   *(p + _lread(hFile, p, MAXSETUPINFOSIZE)) = 0;
   _lclose(hFile);
   fOk = ReadSetupInfo(p);
   GlobalUnlock(hGlbl);
   GlobalFree(hGlbl);
   return(fOk ? ISI_NOERROR : ISI_CANTPARSE);
}

// Set the cursor to an hourglass before this call is made
BOOL SETUPINFO::ReadSetupInfo (char FAR * lpSetupInfo) {
   char szLine[MAXPARSELINELEN];
   LPSTR p, szData;

   while (ReadState != RS_TERMINATE) {

      // Read next line from data buffer.
      p = _fstrchr(lpSetupInfo, '\r');
      if (p != NULL) *p = 0;
      lstrcpy(szLine, lpSetupInfo);
      if (p != NULL) lpSetupInfo = p + 2;

      // Remove leading white-space.
      StripEndBlanks(szLine);

      // Check if the state has changed.
      if (*szLine == '[') {
         ReadState = RS_UNDEFINED;

         if (!lstrcmpi(szLine, "[End]"))     ReadState = RS_TERMINATE;
         if (!lstrcmpi(szLine, "[App]"))     ReadState = RS_APPLICATION;
         if (!lstrcmpi(szLine, "[Disks]"))   ReadState = RS_DISKS;
         if (!lstrcmpi(szLine, "[SrcDirs]")) ReadState = RS_SRCDIRS;
         if (!lstrcmpi(szLine, "[DstDirs]")) ReadState = RS_DSTDIRS;
         if (!lstrcmpi(szLine, "[Files]"))   ReadState = RS_FILES;
         if (!lstrcmpi(szLine, "[PM Info]")) ReadState = RS_PMINFO;

         if (ReadState == RS_UNDEFINED) {
            // Unrecognized section in SETUP.INF file.
            return(FALSE); // Parse was not successful
         }
         continue;
      }

      // Line is part of the current state.
      if (*szLine == ';') continue;    // Is it a comment?
      if (*szLine == 0) continue;      // Is it blank?

      switch (ReadState) {
         case RS_UNDEFINED: break;
         case RS_TERMINATE: break;
         case RS_APPLICATION:

            if ((szData = _fstrchr(szLine, '=')) != NULL) *szData++ = 0;
            // szLine is start of line up to equal sign ('=')
            // szData is remainder of line after equal sign ('=')

            if (!lstrcmpi(szLine, "AppName")) lstrcpy(szAppName, szData);
            if (!lstrcmpi(szLine, "DefDir"))  lstrcpy(szDefaultDstDir, szData);
            if (!lstrcmpi(szLine, "SpaceNeeded")) uSpaceNeeded = latoi(szData);
            if (!lstrcmpi(szLine, "DefPMGroup")) {
               p = _fstrchr(szData, ','); *p = 0;
               lstrcpy(szPMGrpFileName, StripEndBlanks(szData));
               lstrcpy(szPMGrpName, StripEndBlanks(p + 1));
            }
            if (!lstrcmpi(szLine, "ShowSubDirCreateStats"))
               fShowSubDirCreateStats =
                  ((*szData == 'Y') || (*szData == 'y'));
            break;

         case RS_DISKS:
            Disks[uNumDisks++] = new DISKINFO(szLine); break;

         case RS_SRCDIRS:
            SrcDirs[uNumSrcDirs++] = new DIRINFO(szLine); break;

         case RS_DSTDIRS:
            DstDirs[uNumDstDirs++] = new DIRINFO(szLine); break;

         case RS_FILES:
            Files[uNumFiles++] = new FILEINFO(szLine); break;

         case RS_PMINFO:
            PMFiles[uNumPMFiles++] = new PMINFO(szLine); break;
      }
   }
   return(TRUE);  // Parse was successful
}
