#include "allwind.h"

#include <bwcc.h>

TMyCommandWindow::TMyCommandWindow(PTWindowsObject AParent, LPSTR ATitle)
: TDialog(AParent, ATitle)
   {
   }

TMyCommandWindow::~TMyCommandWindow()
   {
   }

void TMyCommandWindow::GetWindowClass(WNDCLASS& WndClass)
   {
   TDialog::GetWindowClass( WndClass );
   WndClass.lpszClassName = "Bordlg_Commander";
   WndClass.hIcon = LoadIcon( GetApplication()->hInstance, "LogoIcon");
   WndClass.lpfnWndProc = BWCCDefDlgProc;
   }

void TMyCommandWindow::WMSize(RTMessage Msg)
   { 
   RECT TraceRect;
   RECT ThisRect;
   RECT EditRect;
   int Xr;
   int Yr;
   int Ye;
   int Yb;
   int Xb;
   
   /* scale and pos. each sub-window in commander window based on its size */
   
   GetClientRect(TraceHWindow,&TraceRect);
   GetClientRect(HWindow,&ThisRect);
   GetClientRect(EditHWindow,&EditRect);
   
   Xr = ThisRect.right-ThisRect.left;
   Yr = ThisRect.bottom-ThisRect.top;
   Ye = EditRect.bottom-EditRect.top;
   Yb = TraceRect.bottom-TraceRect.top;
   Xb = TraceRect.right-TraceRect.left;
   
   SetWindowPos(ListHWindow,   NULL,        4,      1, Xr-Xb*2-10, Yr-Ye-5, 0);
   SetWindowPos(EditHWindow,   NULL,        4,Yr-Ye-2, Xr-Xb*2-10,      Ye, 0);
   
   SetWindowPos(HaltHWindow,   NULL,Xr-Xb*2-4, Yb*0+1,       Xb*1,      Yb, 0);
   SetWindowPos(TraceHWindow,  NULL,Xr-Xb*1-4, Yb*0+1,       Xb*1,      Yb, 0);
   SetWindowPos(PauseHWindow,  NULL,Xr-Xb*2-4, Yb*1+1,       Xb*1,      Yb, 0);
   SetWindowPos(StatusHWindow, NULL,Xr-Xb*1-4, Yb*1+1,       Xb*1,      Yb, 0);
   SetWindowPos(YieldHWindow,  NULL,Xr-Xb*2-4, Yb*2+1,       Xb*1,      Yb, 0);
   SetWindowPos(ResetHWindow,  NULL,Xr-Xb*1-4, Yb*2+1,       Xb*1,      Yb, 0);
   
   SetWindowPos(ExecuteHWindow,NULL,Xr-Xb*2-4,Yr-Ye-2,       Xb*2,      Ye, 0);
   
   }

void TMyCommandWindow::DoEditBox(RTMessage Msg)
   { 
   }

void TMyCommandWindow::DoListBox(RTMessage Msg)
   { 
   DWORD Idx;
   
   SelectedText[0] = '\0';
   
   /* if user clicks on a new selection copy it to edit box */
   
   if ( Msg.LP.Hi == LBN_SELCHANGE )
      {
      Idx = SendDlgItemMsg(ID_LISTBOX, LB_GETCURSEL, 0, 0L);
      SendDlgItemMsg(ID_LISTBOX, LB_GETTEXT, (WORD)Idx, (DWORD)SelectedText);
      SendDlgItemMsg(ID_EDITINPUT, WM_SETTEXT, 0, (DWORD)SelectedText);
      }
   
   /* and if he double clicks then force a click on execute button */
   
   else if ( Msg.LP.Hi == LBN_DBLCLK )
      {
      DoButtonExecute(Msg);
      }
   
   }

void do_execution(char * SelectedText2)
   {
   NODE *exec_list = NIL;
   NODETYPES this_type;
   int i;
   char *c;
   
   /* if something there continue */
   
   if (strlen(SelectedText2) != 0)
      {
      
      /* if executing then it's ok to halt */
      
      halt_flag++;
      if (halt_flag < 1) halt_flag = 1;
      
      /* this code emulates the TTY model used in UCBLOGO main loop */
      
      this_type = STRING;
      c = SelectedText2;
      
      /* do control character processing processing */
      
      for (c=SelectedText2;*c!='\0';c++)
         {
         if (*c == '\\')
            {
            strcpy(c,c+1);
            if (*c)
               {
               if (*c == 'n') *c = '\n';
               *c = setparity(*c);
               }
            this_type = BACKSLASH_STRING;
            }
         }
      
      //      sv_current_line = current_line;
      //      current_line = NIL;
      
      /* turn text into a NODE and parse it */
      
      current_line = reref(current_line, make_strnode(SelectedText2, (char *)NULL, (int)strlen(SelectedText2), this_type, strnzcpy));
      
      exec_list = reref(exec_list, parser(current_line, TRUE));
      
      /* now process it */
      
      val_status = 0;
      if (exec_list != NIL) eval_driver(exec_list);
      
      /* process special conditions */
      
      for (i=0;i<1;i++)
         {
         if (stopping_flag == THROWING)
            {
            if (compare_node(throw_node, Error, TRUE) == 0)
               {
               err_print();
               }
            else if (compare_node(throw_node, System, TRUE) == 0)
               {
               break;
               }
            else if (compare_node(throw_node, Toplevel, TRUE) != 0)
               {
               err_logo(NO_CATCH_TAG, throw_node);
               err_print();
               }
            stopping_flag = RUN;
            }
         
         if (stopping_flag == STOP || stopping_flag == OUTPUT)
            {
            print_node(stdout, make_static_strnode(
            "You must be in a procedure to use OUTPUT or STOP.\n"));
            stopping_flag = RUN;
            }
         }
      
      /* deallocate the line */
      
      current_line = reref(current_line, NIL);
      
      //      current_line = sv_current_line;
      
      /* this is a hack to force garbage collector to properly clean up */
      
      if (exec_list != NIL)
         {
         settype(exec_list,CONS);
         exec_list = reref(exec_list, NIL);
         }
      
      /* not ok to halt now */
      
      halt_flag--;
      if (halt_flag < 0) halt_flag = 0;
      }
   
   }

void TMyCommandWindow::DoButtonExecute(RTMessage Msg)
   { 
   char SelectedText2[MAX_BUFFER_SIZE];
   
   SelectedText2[0] = '\0';
   
   /* get what's in the edit box */
   
   getcombobox(SelectedText2);
   
   /* if real do something with it */
   
   if (strlen(SelectedText2))
      {
      
      /* copy to list box for command recall */
      
      putcombobox(SelectedText2);
      
      /* if dribble then dribble */
      
      if (dribblestream != NULL) fprintf(dribblestream, "%s\n", SelectedText2);
      
      /* reset evaluation counter (call counter) and execute */
      
      eval_count = 0;
      
      do_execution(SelectedText2);
      
      }
   
   /* if we just poped up editor then don't set focus to commander input */
   
   if (!JustDidEdit) SetFocus(EditHWindow);
   JustDidEdit = 0;
   
   }

void TMyCommandWindow::DoButtonStatus(RTMessage Msg)
   { 
   
   /* toggle status state along with poping up and killing the status window */
   
   if (status_flag)
      {
      ((TMyWindow *)MainWindowx)->MyPopupStatusKill();
      SetFocus(EditHWindow);
      }
   else
      {
      ((TMyWindow *)MainWindowx)->MyPopupStatus();
      }
   }

void TMyCommandWindow::DoButtonReset(RTMessage Msg)
   { 
   
   /* just do a clear screen and return focus */
   
   lclearscreen();
   SetFocus(EditHWindow);
   }

void TMyCommandWindow::DoButtonYield(RTMessage Msg)
   { 
   
   /* toggle yield state */
   
   if (yield_flag)
      {
      yield_flag = 0;
      SendDlgItemMsg(ID_YIELD, WM_SETTEXT, 0, (DWORD)"Yield");
      }
   else
      {
      yield_flag = 1;
      SendDlgItemMsg(ID_YIELD, WM_SETTEXT, 0, (DWORD)"NoYield");
      }
   SetFocus(EditHWindow);
   }

void TMyCommandWindow::DoButtonPause(RTMessage Msg)
   { 
   
   /* if ok to halt then it's ok to pause if we get here */
   
   SetFocus(EditHWindow);
   if (halt_flag != 0) Time_To_Pause = 1;
   }

// Will put pack later
//
//void do_pause_update(long arg)
   //   { 
   //   if (arg)
      //      {
      //      sprintf(YABuffer,"Pause-%d",(int)arg);
      //      }
   //   else
      //      {
      //      sprintf(YABuffer,"Pause");
      //      }
   //   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->
   //   SendDlgItemMsg(ID_PAUSE, WM_SETTEXT, 0, (DWORD)YABuffer);
   //   }

void TMyCommandWindow::DoButtonTrace(RTMessage Msg)
   { 
   
   /* toggle trace state */
   
   if (traceflag)
      {
      traceflag = 0;
      SendDlgItemMsg(ID_TRACE, WM_SETTEXT, 0, (DWORD)"Trace");
      }
   else
      {
      traceflag = 1;
      SendDlgItemMsg(ID_TRACE, WM_SETTEXT, 0, (DWORD)"UnTrace");
      }
   SetFocus(EditHWindow);
   }

void TMyCommandWindow::DoButtonHalt(RTMessage Msg)
   { 
   int i;
   
   for (i=1;i<32;i++) KillTimer(MainHWindow, i);
   
   /* if ok to halt and we get here then halt */
   
   SetFocus(EditHWindow);
   if (halt_flag != 0) Time_To_Halt = 1;
   }

void TMyCommandWindow::DefWndProc( RTMessage msg )
   {
   RECT  wrect;
   char  szWinLocStr[WININISIZ];
   int   w, h;
   
   if (msg.Message == WM_DESTROY)
      {
      // Get location and size of our window on the screen so we can
      // come back up in the same spot next time we are invoked.
      
      if (!IsIconic(CmdHWindow))
         {
         GetWindowRect(CmdHWindow, (LPRECT) &wrect);
         w = wrect.right - wrect.left;
         h = wrect.bottom - wrect.top;
         
         // Make a string with our window location and size.
         sprintf(szWinLocStr, "%d,%d,%d,%d", wrect.left, wrect.top, w, h);
         
         // Save in WIN.INI file.
         WritePrivateProfileString(
         "LOGO",
         "Commander",
         szWinLocStr,
         "LOGO.INI");
         }
      
      }
   
   TDialog::DefWndProc( msg );
   }

void do_trace_update(long arg)
   { 
   
   /* update trace button for when logo trace command is issued */
   
   if (arg)
      {
      sprintf(YABuffer,"UnTrace");
      }
   else
      {
      sprintf(YABuffer,"Trace");
      }
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->
   SendDlgItemMsg(ID_TRACE, WM_SETTEXT, 0, (DWORD)YABuffer);
   }

NODE *lhalt()
   {
   if (halt_flag != 0) Time_To_Halt = 1;
   return(UNBOUND);
   }

NODE *lyield()
   {
   
   // set flag and update button label
   
   yield_flag = 1;
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->
   SendDlgItemMsg(ID_YIELD, WM_SETTEXT, 0, (DWORD)"NoYield");
   return(UNBOUND);
   }

NODE *lnoyield()
   {
   
   // clear flag and update button label
   
   yield_flag = 0;
   ((TMyCommandWindow *)((TMyWindow *)MainWindowx)->CommandWindow)->
   SendDlgItemMsg(ID_YIELD, WM_SETTEXT, 0, (DWORD)"Yield");
   return(UNBOUND);
   }
