/*****************************************************************
Module name: Setup.H
Programmer : Jeffrey M. Richter.
*****************************************************************/

// Defines used by the SETUP program.
#define MAXPATH      80
#define MAXDRIVE      3
#define MAXDIR       66
#define MAXFILE       9
#define MAXEXT        5
#define MAXFILENAME  (MAXFILE + MAXEXT)

#define ARRAY_LEN(Array)   (sizeof(Array) / sizeof(Array[0]))
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#define max(a,b)    (((a) > (b)) ? (a) : (b))

extern char _szAppName[];
extern const cdecl HINSTANCE _hInstance;
extern char _szSrcDir[MAXDIR];
extern char _szDstDir[MAXDIR];

extern HINSTANCE _hInstVer;   // Handle of VER.DLL library
extern UINT (WINAPI *_VerFindFile)(UINT, LPCSTR, LPCSTR, LPCSTR,
   LPSTR, UINT FAR*, LPSTR, UINT FAR*);
extern DWORD (WINAPI* _VerInstallFile)(UINT, LPCSTR, LPCSTR,
   LPCSTR, LPCSTR, LPCSTR, LPSTR, UINT FAR*);
extern DWORD (WINAPI* _GetFileVersionInfoSize)
   (LPCSTR, DWORD FAR *);
extern BOOL  (WINAPI* _GetFileVersionInfo)
   (LPCSTR, DWORD, DWORD, void FAR*);
extern UINT  (WINAPI* _VerLanguageName)(UINT, LPSTR, UINT);
extern BOOL  (WINAPI* _VerQueryValue)
   (const void FAR*, LPCSTR, void FAR* FAR*, UINT FAR*);


// Prototypes for various functions.
BOOL WINAPI RegisterDDEClient (HINSTANCE hInstance);
BOOL CALLBACK InitDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam);
BOOL CALLBACK WelcomeDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam);
BOOL CALLBACK StatusDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam);
BOOL CALLBACK InsertDiskDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam);
BOOL CALLBACK FileInUseDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam);


typedef struct {
   char szExistingPath[MAXPATH], szSrcPath[MAXPATH];
   char szTmpPath[MAXPATH];
   DWORD dwVIFResult;
} MISMATCHSTRUCT, FAR *LPMISMATCHSTRUCT;
BOOL CALLBACK MismatchDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam);

typedef struct {
   char szDstFileName[MAXPATH], szDstDir[MAXPATH];
   char szCurDir[MAXPATH];
} CURNEDESTSTRUCT, FAR *LPCURNEDESTSTRUCT;
BOOL CALLBACK CurNEDestDlgProc (HWND hDlg, UINT uMsg,
   WPARAM wParam, LPARAM lParam);


int _cdecl MsgBox (HINSTANCE hInstance, HWND hWnd, WORD wID,
   LPCSTR szCaption, WORD wType, ...);


// Defines for use with SETUP's string table.
#define IDS_CANNOTINIT        1001
#define IDS_NOMEMORY          1002
#define IDS_NOSETUPINFOFILE   1003
#define IDS_NODISKSPACE       1004
#define IDS_SETUPNOGOOD       1005
#define IDS_PMADDOK           1006
#define IDS_PMADDNOGOOD       1007
#define IDS_CANTMAKEDIR       1008
#define IDS_QUERYABORT        1009
#define IDS_FILEINUSE         1010
#define IDS_UNRECOVERABLE     1011
#define IDS_OUTOFSPACE        1012
#define IDS_ACCESSVIOLATION   1013
#define IDS_SHARINGVIOLATION  1014
#define IDS_CANNOTCREATE      1015
#define IDS_CANNOTDELETE      1016
#define IDS_CANNOTRENAME      1017
#define IDS_OUTOFMEMORY       1018
#define IDS_CANNOTREADSRC     1019
#define IDS_CANNOTREADDST     1020
#define IDS_WRITEPROT         1021
#define IDS_MISMATCH          1022
#define IDS_SRCOLD            1023
#define IDS_DIFFLANG          1024
#define IDS_DIFFCODEPG        1025
#define IDS_DIFFTYPE          1026




//***** Macros for using Window and Class Extra Bytes ************

#define GETWNDEB(hWnd, Struct, Member) \
   ( \
      (sizeof(((Struct FAR *)0)->Member) == sizeof(LONG)) ? \
      ((LONG)GetWindowLong(hWnd, FIELDOFFSET(Struct, Member))) :\
      ((WORD)GetWindowWord(hWnd, FIELDOFFSET(Struct, Member))) \
   )


#define SETWNDEB(hWnd, Struct, Member, Value) \
   ( \
      (sizeof(((Struct FAR *)0)->Member) == sizeof(LONG)) ? \
      ((LONG)SetWindowLong(hWnd, FIELDOFFSET(Struct, Member), \
         (LONG)(Value))) : \
      ((WORD)SetWindowWord(hWnd, FIELDOFFSET(Struct, Member), \
         (WORD)(Value))) \
   )


#define GETCLSEB(hWnd, Struct, Member) \
   ( \
      (sizeof(((Struct FAR *)0)->Member) == sizeof(LONG)) ? \
      ((LONG)GetClassLong(hWnd, FIELDOFFSET(Struct, Member))) : \
      ((WORD)GetClassWord(hWnd, FIELDOFFSET(Struct, Member))) \
   )

#define SETCLSEB(hWnd, Struct, Member, Value) \
   ( \
      (sizeof(((Struct FAR *)0)->Member) == sizeof(LONG)) ?  \
      ((LONG)SetClassLong(hWnd, FIELDOFFSET(Struct, Member), \
         (LONG)(Value))) : \
      ((WORD)SetClassWord(hWnd, FIELDOFFSET(Struct, Member), \
         (WORD)(Value))) \
   )

//************* Identifiers used in Dialog Boxes *****************
#define DLG_FIRST          1
#define DLG_INITIALIZE     1
#define DLG_WELCOME        2
#define DLG_INSERTDISK     3
#define DLG_STATUS         4
#define DLG_CURNEDEST      5
#define DLG_FILEINUSE      6
#define DLG_MISMATCH       7
#define DLG_LAST           7
#define ICN_FIRST          10
#define ICN_SETUP          10
#define ICN_DISK           11
#define ICN_LAST           11

#define ID_METER           100
#define ID_DESTPATH        101
#define ID_DISKNAME        102
#define ID_STATLINE1       103
#define ID_STATLINE2       104
#define ID_SRCPATH         105

// Identifiers for CURNEDEST Dialog box
#define ID_DSTFILENAME        100
#define ID_DSTDIR             101
#define ID_CURDIR             102
#define ID_INSTALLANDDELETE   103
#define ID_INSTALLANDKEEP     104
#define ID_REPLACEEXISTING    105
#define ID_SKIPINSTALL        106
#define ID_ABORTINSTALL       107

// Identifiers for FILEINUSE Dialog box
#define ID_FILENAMEINUSE      100
   // Also uses, IDRETRY, IDABORT, IDIGNORE, and IDOK


// Identifiers for DLG_MISMATCH Dialog box
#define ID_VERMISMATCHTEXT    100
#define ID_VERINFOEXISTING    101
#define ID_VERINFONEW         102
   // Also uses, IDOK, IDCANCEL, and IDABORT
