#include "pwinc.h"                          /* main include file */

int _pwv_scrncol = 80;
int _pwv_scrnrow = 25;
int _pwv_scrtype = 2;                       /* assume EGA first */
int _pwv_scrsnow = 0;                       /* no snow checking */
PWCELL far *_pwv_scrbuf;
unsigned char far *_pwv_levbuf;

static int pwv_shadbg[2][8] = {
    {0x00, 0x00, 0x00, 0x20, 0x00, 0x10, 0x00, 0x00},   /* CGACOLOR */
    {0x00, 0x10, 0x40, 0x50, 0x20, 0x60, 0x30, 0x70}    /* CGAMONO */
};
static int pwv_shadfg[2][16] = { 
    {0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,    /* CGACOLOR */
     0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x07, 0x07},
    {0x00, 0x00, 0x05, 0x06, 0x00, 0x01, 0x08, 0x0c,    /* CGAMONO */
     0x04, 0x02, 0x0d, 0x07, 0x09, 0x03, 0x0a, 0x0b}
};

PWCELL pwv_shadecell(PWCELL cell)
{
    int attr, nattr;

    if (_pwcf_mon == PWCF_MDAMONO)
        return cell;
    /* _pwcf_mon must be != PWCF_MDAMONO !!! */
    attr = cell >> 8;
    nattr = (attr & 0x80) +                 /* old blinking bit */
        pwv_shadfg[_pwcf_mon][(attr & 0x0f)] +   /* new foreground */
        pwv_shadbg[_pwcf_mon][(attr & 0x70)>>4]; /* new background */
    return ((cell & 0x0ff) + (PWCELL)(nattr<<8));
}

unsigned char pw_attrib(int wintype, int texttype)
{
    return _pwcf_attrib[((_pwcf_mon*PWCF_WINS)+(wintype))*PWCF_TTYPES + 
                         (texttype)];
}

