/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IPLOOP.C
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/6/14
**
** DESCRIPTION: Contains a software loopback interface.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.1  $
** WORKFILE:    $Workfile:   IPLOOP.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/IFACE/VCS/IPLOOP.C_V  $
**              
**                 Rev 1.1   21 Nov 1990 14:38:28   etstjan
**              No explicit note
**              
**                 Rev 1.0   20 Nov 1990 15:34:58   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/IFACE/VCS/IPLOOP.C_V   1.1   21 Nov 1990 14:38:28   etstjan  $";
#endif

#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <beholder.h>

#include    "ip.h"                   /* global IP type definitions    */
#include    "ipcodes.h"              /* contains all the return codes */
#include    "iplib.h"
#include    "ipif.h"
#include    "ipevents.h"             /* event and timer processing    */
#include    "iplayer.h"
#include    "iploop.h"               /* header file for this file     */

IFDESCRIPTOR  *LoopDescr;            /* pointer to if descriptor */


/************************************************************************
** NAME:        IPLoopInit
** SYNOPSIS:    int IPLoopInit(IFDESCRIPTOR *IfDesc);
**
** DESCRIPTION: Initializes the software loopback interface
**              Parameters are stored in strings, should later
**              be read from initialization file.
**              IP Buffer Management MUST have been initialized
**              before calling IPLoopInit.
**              The necessary field in the interface descriptor
**              are initialized as well.
** RETURNS:     NO_ERR -->   no error
**              else    error code
** USES:
*************************************************************************/
int IPLoopInit(IFDESCRIPTOR *IfDesc)
{

  /* set global interface descriptor fields */
  LoopDescr = IfDesc;
  IfDesc->Flags |= IF_UP | IF_RUNNING;
  IfDesc->SendFun = IPLoopSend;

  return NO_ERR;                            /* everything is just fine */
}

/**************************************************************
** NAME:        IPLoopSend
** SYNOPSIS:    int   IPLoopSend(LLREQ Request,
**                               DATALINK* Packet, ADDRESS_T Dest)
**
** DESCRIPTION: Implements a software loopback interface
**              for the IP package. The destination address
**              is set equal to the source address. Next,
**              the packet is copied to a contiguous byte
**              buffer and a receive event is scheduled.
** RETURNS:     NO_ERR  -->   no error
**              else          error code
**************************************************************/
int   IPLoopSend(LLREQ Request, DATALINK* Packet, ADDRESS_T Dest)
{
  DATALINK    *TmpPnt;
  int         RetCode = NO_ERR;
  EVENTUNION  LoopRecUnion;

  LoopDescr->NrSendReq++;
  if ((LoopDescr->Flags & IF_UP) != IF_UP) {
     RetCode = IF_DOWN;
     }
  else {
    switch (Request) {
      case SENDREQ :
      case BROADREQ:
        if ((TmpPnt = IPDataLinkGet(DLinkLen(Packet))) == NULL) {
          IPReport(NOSPACE, NULL, NULL);
          LoopDescr->NrSysErrors++;
          RetCode = NOSPACE;
          }
        else {
          DLinkToByte(TmpPnt->DataStart, Packet);
          TmpPnt->ThisType = DATAHD;
          LoopDescr->NrSend++;
          LoopDescr->NrRecReq++;
          LoopRecUnion.RecData.If = LoopDescr;
          LoopRecUnion.RecData.RecPacket = TmpPnt;
          LoopRecUnion.RecData.LinkBrdCst = 0;
          if (Schedule(LOW, IPReceive, &LoopRecUnion) != NO_ERR) {
            LoopDescr->NrSysErrors++;
            DiscardAll(TmpPnt);
            RetCode = NOSPACE;
            }
          else {
            LoopDescr->NrReceived++;
            }
          }
          break;
      default :
        RetCode = ILL_REQUEST;
        break;
      }
    }
  return RetCode;
}





