/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGVSCR.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Vertical scroll function
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include "pwinc.h"                          /* main include file */

/* [DOC] Function *********************************************
** Name:        pw_vscroll                                [API]
** SYNOPSIS:    void pw_vscroll(win, srow, scol, nrow, ncol, 
**                              nscrolls)
**              PWWIN *win          Pointer to window handle
**              int   srow, scol    Topleft scroll area
**              int   nrow, ncol    Bottomright scroll area
**              int   nscrolls      # of rows to scroll
** Descr:       Scrolls a portion of window vertically.
**              The 'pw_vscroll' function scrolls the window
**                'win' vertically by a number of lines.
**              If 'nscrolls'<0: scroll -'nscrolls' lines down.
**              If 'nscrolls'>0: scroll 'nscrolls' lines up.
**              If 'nrow' == 0 or 'ncol' == 0:
**                the function will make the scroll area
**                as large as possible (window size).
**              The attribute used for the new lines is
**                PWT_NORMAL.
** RETURNS:     void
** EXAMPLE:         ...Scroll an entire window 2 lines up:...
**              pw_vscroll(example_win, 0, 0, 0, 0, 2);        
**                  ....
** SEE ALSO:    pw_hscroll
**************************************************************/
void pw_vscroll(PWWIN *win, int srow, int scol, int nrow, int ncol,
                int nscrolls)
{
    int row = (nrow) ? nrow : win->nrow-srow;
    int col = (ncol) ? ncol : win->ncol-scol;

    if (nscrolls<0)
        pwb_scroll_down(win, srow, scol, row, col, -nscrolls);
    else
        pwb_scroll_up(win, srow, scol, row, col, (nscrolls) ? nscrolls : row);
}


