/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGBLOC.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Block texttype change function for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include "pwinc.h"                          /* Main include file */

/* [DOC] Function *********************************************
** Name:        pw_block                                  [API]  
** SYNOPSIS:    void pw_block(win, srow, scol, nrow, ncol,
**                            ttype);
**              PWWIN *win          Pointer to window handler
**              int   scol          Top left column of block
**              int   srow          Top left row of block
**              int   ncol          Width of block
**              int   nrow          Height of block
**              int   ttype         New texttype
** Descr:       Changes the attribute of a block of text.
**              The 'pw_block' function changes the texttype
**                of a block within the window 'win', determined
**                by 'scol','srow' and 'ncol','nrow'.
**              Valid texttypes are defined in include file
**                POWER3.H.  They all start with PWT_...
**              Characters in that block are not affected
**                only their attributes change.
**              The cursor position is NOT changed.
** RETURNS:     void
**************************************************************/
void pw_block(PWWIN *win, int srow, int scol, int nrow, int ncol, int ttype)
{
    int i, j;
    int attr = pwv_attrib(win->wtype, ttype);
    int oldrow = win->crow;                 /* save cursor pos */
    int oldcol = win->ccol;

    if (!nrow)
        nrow = win->nrow-srow;              /* maximum rows */
    if (!ncol)
        ncol = win->ncol-scol;              /* maximum columns */
    win->crow = srow;
    win->ccol = scol;
    for (i=nrow; i; i--)                    /* for all rows */
    {
        pwv_cursor(win);
        for (j=ncol; j; j--)                /* for all columns */
            pwv_putattr(win, attr);
        win->crow++;
    }
    win->crow = oldrow;                     /* restore cursor pos */
    win->ccol = oldcol;
}
