/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWCONV.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Conversion program for
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include <stdio.h>
#include <stdlib.h>                         /* for exit() */
#include <string.h>                         /* for str*() */
#include <ctype.h>                          /* for toupper() */
#include "power3.h"                         /* for pw_*() */
#include "pwconv.h"                         /* prototyping */
#include "pwcvpw.h"

#define LEN_PATH        128
#define LEN_WORD        128
#define EMPTYPEEK       -11
#define COMMENT         -2
#define ENDCOMMENT      -3

char progname[] =        "PWCONV";
char progdate[] =        "July 1989";
char progcreator[] =     "CSE Computer Systems Expertise";
char progver[]  =        "v1.00";
char proguse[]  =        "[Options]";

char param[10][LEN_PARAM];
int npwkeys;                          /* # of pw_key elements */

char *main_menu[] = 
{
    "Input file",
    "Output file",
    "Package",
    "Convert",
    "Trace",
    "Quit",
    NULL
};
char *package_menu[] = 
{
    "POWER 1.xx",
    "FEW 1.50  ",
    "FEW 2.0   ",
    NULL
};
int  wintype = 0;
char *trace_menu[] = 
{
    "Trace OFF",
    "Trace ON ",
    NULL
};
int trace = 0;
char infile[LEN_PATH];
char outfile[LEN_PATH];
PWWIN *status_win;
int peek = EMPTYPEEK;
int incomment = 0;
int instring = 0;
int parlevel = 0;
int inline = 1;
FILE *infh;
FILE *outfh;
PWWIN *inwin;
PWWIN *outwin;

/* ***********************************************************\
Reads characters from input file.
Same as fgetc(FILE *infh).
Keeps count of input file line and column numbers.
If not in string parsing function parsestring() (instring == 0)
    Converts "\/\*" into COMMENT.
If in comment parsing function parsestring() (incomment != 0)
    Converts "\*\/" into ENDCOMMENT.
\* ***********************************************************/
int readchar()
{
    int c;

    if (peek == EMPTYPEEK)                  /* look-ahead ? */
    {
        c = fgetc(infh);                    /* get next char */
        if (trace == 1)
            pw_putc(inwin, c);
    }
    else
    {
        c = peek;                           /* next char already read */
        peek = EMPTYPEEK;                   /* no look-ahead */
    }
    if (c == '\n')
        inline++;
    if (instring)
        return c;
    if (incomment)
    {
        if ((c == '*') &&
            ((peek = fgetc(infh)) == '/'))
        {
            if (trace == 1)
                pw_putc(inwin, peek);
            c = ENDCOMMENT;
            peek = EMPTYPEEK;
            incomment = 0;
        }
    }
    else
    {
        if ((c == '/') &&
            ((peek = fgetc(infh)) == '*'))
        {
            if (trace == 1)
                pw_putc(inwin, peek);
            c = COMMENT;
            peek = EMPTYPEEK;
            incomment = -1;
        }
    }
    if (c == '(')
        parlevel++;
    else
    {
        if (c == ')')
            parlevel--;
    }
    return c;
}

/* ***********************************************************\
Skips preceeding space characters.
Reads letter characters from input file into 'word'.
Stops reading when not-letter character, or 'len' exceeded.
\* ***********************************************************/
char *readword(word, len)
char *word;
int len;
{
    int c;
    int i = 0;
    int ret = 0;

    c = readchar();
    while ((c != EOF) && (!iscsym(c)) && (c != '.'))
    {
        switch(c)
        {
        case COMMENT:
            if (trace == 1)
                writeword("[C]");
            writeword("/*");
            while (((c=readchar()) != EOF) && (c != ENDCOMMENT))
                writechar(c);
            writeword("*/");
            if (trace == 1)
                writeword("[c]");
            break;
        case '\'':
        case '"':
            if (trace == 1)
                writeword("[S]");
            instring = c;
            writechar(instring);
            while (((c=readchar()) != EOF) && (c != instring))
                writechar(c);
            writechar(instring);
            if (trace == 1)
                writeword("[s]");
            instring = 0;
            break;
        default:
            writechar(c);
            break;
        }
        c = readchar();
    }
    while ((c != EOF) && (i < len) && ((iscsym(c)) || (c == '.')))
    {
        word[i++] = (char)c;
        if (i < len)
            c = readchar();
    }
    word[i] = '\0';
    if ((c != EOF) && (i < len))
        peek = c;                       /* put back last character */
    return word;
}

/* ***********************************************************\
Writes characters to output file.
Same as fputc(int c, FILE *outfh).
Keeps count of output file line and column numbers.
Takes care of ENtab or DEtab tabs and spaces.
\* ***********************************************************/
void writechar(c)
int c;
{
    if (trace == 1)
        pw_putc(outwin, c);
    fputc(c, outfh);
}

void writeparam(par)
char *par;
{
    int c;
    char word[LEN_WORD];
    int i;

    if (trace == 1)
        writeword("[P]");
    while (c = *par)
    {
        while (c && !iscsym(c) && (c != '.'))
        {
            writechar(c);
            c = *(++par);
        }
        i = 0;
        while (c && (iscsym(c) || (c == '.')))
        {
            word[i++] = (char)c;
            c = *(++par);
        }
        if (i)
        {
            word[i] = '\0';
            conv_word(word);
        }
    }
    if (trace == 1)
        writeword("[p]");
}

void writeword(word)
char *word;
{
    while (*word)
        writechar(*(word++));
}

int array_to_number(array, keyword)
char *array[];
char *keyword;
{
    int key = 0;

    while ((array[key]) && (strcmp(array[key], keyword) != 0))
        key++;
    if (array[key])
        return key;
    else
        return -1;
}

void initparam(n)
int n;
{
    int i, c;

    c = readchar();
    while ((c!=EOF) && (c != '('))
    {                                   /* find begin of function */
        writechar(c);
        c = readchar();
    }
    writechar('(');
    for (i=0; i<n; i++)
        readparam(param[i], LEN_PARAM);
}

char *readparam(param, len)
char *param;
int len;
{
    int c;
    int i = 0;
    int ret = 0;
    int level;

    level = parlevel;
    c = readchar();
    while ((c!=EOF) && ((c==' ') || (c=='\t')))
        c = readchar();                 /* strip leading spaces */
    while ((c != EOF) && (i<len) &&
           ( (c != ',') || (parlevel > level) ) &&
           parlevel >= level)
    {
        switch (c)
        {
        case COMMENT:
            if (trace == 1)
            {
                param[i++] = '[';
                param[i++] = 'C';
                param[i++] = ']';
            }
            param[i++] = '/';
            param[i++] = '*';
            while (((c=readchar()) != EOF) && (c != ENDCOMMENT))
                param[i++] = (char)c;
            param[i++] = '*';
            param[i++] = '/';
            if (trace == 1)
            {
                param[i++] = '[';
                param[i++] = 'c';
                param[i++] = ']';
            }
            break;
        case '\'':
        case '"':
            if (trace == 1)
            {
                param[i++] = '[';
                param[i++] = 'S';
                param[i++] = ']';
            }
            instring = c;
            param[i++] = (char)instring;
            while (((c=readchar()) != EOF) && (c != instring))
                param[i++] = (char)c;
            param[i++] = (char)instring;
            if (trace == 1)
            {
                param[i++] = '[';
                param[i++] = 's';
                param[i++] = ']';
            }
            instring = 0;
            break;
        default:
            param[i++] = (char)c;
            break;
        }
        if (i < len)
            c = readchar();
    }
    while ((--i > 0) && ((param[i] == ' ') || (param[i] == '\t')))
        ;                               /* strip trailing spaces */
    param[++i] = '\0';
    if (c == EOF)
        pw_error("Unexpected EOF at line %d; conversion aborted", inline);
    if ((c != EOF) && (i < len) && (c!= ','))
        peek = c;                       /* put back last character */
    parlevel = level;
    return param;
}

void conv_few20(word)
char *word;
{
    word = word;
}

void conv_word(word)
char *word;
{
    switch (wintype)
    {
        case 0:
        conv_pw1(word);
        break;
    case 1:
        conv_few15(word);
        break;
    case 2:
        conv_few20(word);
        break;
    }
}

int proc_main_menu(element)
int element;
{
    char word[LEN_WORD];

    switch (element) 
    {
    case 0:                                 /* Input file */
        pw_input(status_win, 1, 2, "Input:", 1, 11, 57, infile, LEN_PATH, NULL, PWM_UPROMPT);
        break;
    case 1:                                 /* Output filename */
        pw_input(status_win, 2, 2, "Output:", 2, 11, 57, outfile, LEN_PATH, NULL, PWM_UPROMPT);
        break;
    case 2:                                 /* window type */
        pw_choice(7, 30, PWC_AUTO, PWC_AUTO, "Package", package_menu, &wintype);
        pw_putsat(status_win, 0, 11, package_menu[wintype]);
        break;
    case 3:                                 /* Convert */
        if (strcmp(infile, outfile) == 0)
            pw_error("Input and Output file must be different");
        else
        {
            if (infh = fopen(infile, "r"))
            {
                if (outfh = fopen(outfile, "w"))
                {
                    if (trace == 1)
                    {
                        inwin  = pw_open( 1, PWC_LEFT, 11, PWC_RIGHT, "Input file", PWM_DEFAULT, PWW_DATA);
                        outwin = pw_open(13, PWC_LEFT, 11, PWC_RIGHT, "Output file", PWM_DEFAULT, PWW_DATA);
                    }
                    else
                        pw_waiton();
                    npwkeys = 0;            /* calculate # pw pw keywords */
                    while (pw_keyword[npwkeys])
                        npwkeys++;

                    while (!feof(infh))
                    {                       /* for all words in file */
                        readword(word, LEN_WORD);
                        if (*word)
                            conv_word(word);
                    }
                    fclose(outfh);
                    if (trace == 1)
                    {
                        pw_getkey();
                        pw_close(inwin);
                        pw_close(outwin);
                    }
                    else
                        pw_waitoff();
                }
                else
                    pw_error("Can't open output file '%s'", outfile);
                fclose(infh);
            }
            else
                pw_error("Can't open input file '%s'", infile);
        }
        break;
    case 4:                                 /* trace */
        pw_choice(7, 30, PWC_AUTO, PWC_AUTO, "Trace", trace_menu, &trace);
        pw_putsat(status_win, 0, 40, trace_menu[trace]);
        break;
    case 5:                                 /* quit */
        return -1;
    }
    return element;
}

void argerror()
{
    fprintf(stderr, "Error in program %s: Invalid number of arguments\n", progname);
    fprintf(stderr, "Usage: %s Configfile[.PWC] [/B]", progname);
    exit(-1);
}

void main(argc, argv)
int   argc;
char *argv[];
{
    PWWIN *hdrwin;
    char temp[SCRATCH_LEN];
    int i = argc-1;
    unsigned int status = 0;

    if ((argv[2][0] == '/') && (toupper(argv[2][1]) == 'M'))
    {
        argc--;
        status = status | 0x01;
    }
    if ((argv[2][0] == '/') && (toupper(argv[2][1]) == 'B'))
    {
        argc--;
        status = status | 0x02;
    }
    if (argc != 1)
        argerror();
    pw_init(argv[0], "INIT", status);
    sprintf(temp, "  %s  -  %s  -  %s  -  %s",
                  progname, progdate, progcreator, progver);
    pw_header(temp);
    status_win = pw_open(19, PWC_CENTER, 3, 70, "Current status", PWM_DEFAULT, PWW_NORMAL);
    pw_putsat(status_win, 0,  2, "Package:");
    pw_putsat(status_win, 0, 11, package_menu[wintype]);
    pw_putsat(status_win, 0, 40, trace_menu[trace]);
    pw_putsat(status_win, 1,  2, "Input:");
    pw_putsat(status_win, 2,  2, "Output:");
    pw_menu(7, 10, PWC_AUTO, PWC_AUTO, "Main menu", main_menu, proc_main_menu, NULL);
    pw_quit();
}

