#************************************************************************
#* MODULE INFORMATION*
#*********************
#*     FILE     NAME:       PKT.MAK
#*     SYSTEM   NAME:       BEHOLDER
#*     ORIGINAL AUTHOR(S):  Jan van Oorschot
#*     VERSION  NUMBER:     1.00
#*     CREATION DATE:       16-10-90
#*
#* DESCRIPTION: Global makefile for the Network DisPatcher's
#*              Packet Driver Handling Library.
#************************************************************************
#* CHANGES INFORMATION **
#************************
#* REVISION:    $Revision:   1.4  $
#* WORKFILE:    $Workfile:   PKT.mak  $
#* LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/NPD/PKT/VCS/PKT.MAV  $
#  
#     Rev 1.4   01 Feb 1991 14:16:56   etstjan
#  
#     Rev 1.3   26 Oct 1990 14:34:26   etstjan
#  
#     Rev 1.2   25 Oct 1990 14:59:06   etstjan
#  
#     Rev 1.1   25 Oct 1990 14:50:50   etstjan
#  Improved .exe generation
#  
#     Rev 1.0   25 Oct 1990 14:34:52   etstjan
#  Initial revision.
#************************************************************************
HOMEDIR=..\..
NEWTREE=.^\
MODEL=L
MODE=r
ID=$(HOMEDIR)\INCLUDE
LD=$(HOMEDIR)\LIB
ED=$(HOMEDIR)\EXE
CFLAGS=/W4 /Oxz /A$(MODEL) /L$(MODE) /I$(ID)
LFLAGS=/STACK:8000
MFLAGS = HOMEDIR=$(HOMEDIR) CFLAGS="$(CFLAGS)" LFLAGS="$(LFLAGS)" MODE=$(MODE) MODEL=$(MODEL)
PUTNOTE="No explicit note"

SYSTEM=PKT
EXE=pdsinfo
LIBS=$(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
CS=pkt.c pkttype.c pktuti.c pktstat.c 
AS=pkt2c.asm
HS=pktdef.h pktinc.h pktdcl.h pkt.h 
MAKS=$(SYSTEM).mak
DOCS=
SRCS=$(CS) $(AS) $(HS) $(DOCS) pkthlp.cmd pktman.cmd
OBJS=pkt.obj pkttype.obj pktuti.obj pktstat.obj pkt2c.obj
EXES=$(EXE).exe
ELIB=$(MODEL)pkt$(MODE).lib $(LD)\$(MODEL)clerr$(MODE).lib \
        $(LD)\$(MODEL)bufm$(MODE).lib \
        $(LD)\$(MODEL)futil$(MODE).lib
EXPORTS=$(ID)\pkt.h \
        $(LD)\$(MODEL)$(SYSTEM)$(MODE).lib
#************************************************************************
#*  Supported make commands:
#*
#*      all     -->     do a full make of this system part
#*      compile -->     do a compile of all c-files
#*      lib     -->     collect all obj's in a lib
#*      exe     -->     make exe's
#*      clean   -->     throw out all garbage
#*      collect -->     copy all .lib and .h files to global directories
#*      put     -->     do a PVCS put of the sources 
#*      get     -->     do a PVCS get of the sources
#*      getlock -->     do a PVCS get of the sources and put a lock on them
#*      makedir -->     Make all subdirectories in the given
#*                      tree $(NEWTREE)
#************************************************************************
all:  lib collect exe
    @echo ....Ready  $(MODEL)$(SYSTEM)$(MODE).lib

compile: $(OBJS)

lib: $(MODEL)$(SYSTEM)$(MODE).lib

exe: $(EXES)

clean:
    @-del *.obj
    @-del *.lib
    @-del *.bak
    @-del *.exe


collect: $(EXPORTS)
    !-copy $(**F) $**

put: $(SRCS)
    !PUT -l -n -t$(PUTNOTE) $**
    PUT -l -n -t$(PUTNOTE) $(SYSTEM).mak

getlock:    $(SRCS)
    !-GET -l -n  $**

get:    $(SRCS)
    !-GET  $**

makedir:
    mkdir $(NEWTREE)\VCS

#************************************************************************
#*  actual components and relations
#************************************************************************
$(MODEL)$(SYSTEM)$(MODE).lib : $(OBJS)
    !LIB $@ -+$**;
    copy $(MODEL)$(SYSTEM)$(MODE).lib $(LD)

$(EXE).exe : $(EXE).c
    cl $(CFLAGS) /Fe$@ $** $(ELIB) /link $(LFLAGS)

pkt2c.obj: pkt2c.asm
    masm /W2 /Ml /DMODEL_$(MODEL) $**,$@;

$(SRCS) :

$(EXPORTS) :
