/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dpffile.c
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/10/26
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPFFILE.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFFILE.C_V  $
**              
**                 Rev 1.0   26 Oct 1990 13:56:00   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFFILE.C_V   1.0   26 Oct 1990 13:56:00   etstjan  $";
#endif
#include <stdio.h>
#include <stdlib.h>                         /* for _MAX_PATH */
#include <malloc.h>                         /* for malloc(), free() */
#include "dpfinc.h"                         /* main include file */
extern DPKEY     DpuGetFile(char *header, char *filemask, char *fname, int *OldElem);

typedef struct _FILT {
    int type;
    int place;
    int offset;
    int length;
    BYTE *andmask;
    BYTE *xormask;
    BYTE *cmpmask;
    struct _FILT *next;
} FILT;

char DpfFilterFile[_MAX_PATH] = "DEFAULT.FIL";
static int FileElem = 0;

static int ProcessEvent(DPEVENT Event);

DPFILT DpfFile = { "File", ProcessEvent, 0 };

static FILT *filtmalloc(int len);
static FILT *filtadd(int typ, int plac, int offs, int len);
static int   filtcmp(BYTE far *buf, FILT *fp);

static int   Filter(void);
static int   Start(void);
static void  Stop(void);

static FILT *firstfilt;

static int ProcessEvent(DPEVENT Event)
{
    int ret = 0;

    switch (Event)
    {
    case DPE_RECEIVEPKT: ret = Filter();        break;
    case DPE_START:      ret = Start();         break;
    case DPE_STOP:             Stop();          break;
    }
    return ret;
}

static FILT *filtmalloc(len)
int len;
{
    FILT *fp;

    if (fp = (FILT *)malloc(sizeof(FILT)))
    {
        if (fp->andmask = (BYTE *)malloc(len))
        {
            if (fp->xormask = (BYTE *)malloc(len))
            {
                if (!(fp->cmpmask = (BYTE *)malloc(len)))
                {
                    free(fp->xormask);
                    free(fp->andmask);
                    free(fp);
                    fp = (FILT *)0;
                }
            }
            else
            {
                free(fp->andmask);
                free(fp);
                fp = (FILT *)0;
            }
        }
        else
        {
            free(fp);
            fp = (FILT *)0;
        }
    }
    return fp;
}

static FILT *filtadd(typ, plac, offs, len)
int typ, plac, offs, len;
{
    FILT *fp;

    if (fp = filtmalloc(len))
    {
        fp->type    = typ;
        fp->place   = plac;
        fp->offset  = offs;
        fp->length  = len;
        fp->next = firstfilt;
        firstfilt = fp;
    }
    return fp;
}

static int filtcmp(buf, fp)
BYTE far *buf;
FILT *fp;
{
    int ret = -1;
    int i = 0;
    int j = fp->offset;

    while ((i<fp->length) && (ret))
    {
        ret = (((buf[j] & fp->andmask[i]) ^ fp->xormask[i]) == fp->cmpmask[i]);
        i++;
        j++;
    }
    return ret;
}

/*************************************************************************
** NAME:        Filter
** SYNOPSIS:    int Filter(frp)
**              FRAME *frp              Pointer to frame struct
** DESCRIPTION: This function filters a frame through all filter elements
**                build up by a previous call to Init().
** RETURNS:      0: Frame did NOT pass filter
**              -1: Frame passed all filter elements
** EXAMPLE:     if (frp = FrRbMalloc(framelength))
**              {
**                  frp->hdrlen = hdrinfo->hdrlen;
**                  frp->datlen = framelength - frp->hdrlen;
**                  frp->hdrptr = (BYTE *)frp + sizeof(FRAME);
**                  frp->datptr = frp->hdrptr + frp->hdrlen;
**                  readframe(frp)
**                  if (!(frp))
**                      FrRbUnMalloc();
**              }
**              else
**                  ... ring buffer full ...
*************************************************************************/
static int Filter(void)
{
    FILT *fp = firstfilt;
    int ret = -1;
    BYTE far *buf;
    DPBUF *frp = DpReceivePkt();

    if (fp)
    {
        ret = 0;
        while (fp)
        {
            switch (fp->place)
            {
            case 'D':
            case 'H':
                buf = frp->pBuf + hdrinfo->DestOff;
                break;
            case 'S':
                buf = frp->pBuf + hdrinfo->SrcOff;
                break;
            case 'T':
                buf = frp->pBuf + hdrinfo->TypOff;
                break;
            case 'F':
                buf = frp->pBuf + hdrinfo->DatOff;
                break;
            default:
                buf = frp->pBuf + hdrinfo->DatOff;
                break;
            }
            if (fp->type == 'I')
                ret = (ret || filtcmp(buf, fp));
            else
                ret = (ret && !filtcmp(buf, fp));
            fp = fp->next;
        }
    }
    return ret;
}

/*************************************************************************
** NAME:        Start
** SYNOPSIS:    int Start(DpfFilterFile)
**              char *DpfFilterFile         File name of filter file
** DESCRIPTION: This function reads the filter file 'DpfFilterFile' and
**                builds up a linked list of filter elements.
**              Subsequent calls to the filter function 'Filter'
**                will use this filter list as the filter criteria
**                for th frames.
**              If the filter file does not exist in the current
**                directory, it assumes an empty filter list
**                (all frames will pass the filter).
**              The function Stop() frees the filter elements
**                previously allocated by a call to Start().
** RETURNS:      0: Successful call
**              -9: Not enough memory
** SEE ALSO:    Filter, Stop
*************************************************************************/
static int Start(void)
{
    FILE *fh;
    int offset, len, i, c;
    char type, place;
    FILT *fp;
    int ret = 0;

    firstfilt = (FILT *)0;
    DpuGetFile("Filterfile", "*.FIL", DpfFilterFile, &FileElem);
    if ((fh = fopen(DpfFilterFile, "r")) != NULL)
    {
        while (!feof(fh))
        {
            if (fscanf(fh, " %c", &type) == 1)
            {
                switch (type)
                {
                case '#':
                    while (((c = fgetc(fh)) != EOF) && (c != '\n'))
                        ;                       /* skip rest of line */
                    break;
                case 'I':
                case 'X':
                    fscanf(fh, " %c %i %i", &place, &offset, &len);
                    if (fp = filtadd(type, place, offset, len))
                    {
                        for (i=0; i<len; i++)
                        {
                            fscanf(fh, "%i", &offset);
                            fp->andmask[i] = (BYTE)offset;
                        }
                        for (i=0; i<len; i++)
                        {
                            fscanf(fh, "%i", &offset);
                            fp->xormask[i] = (BYTE)offset;
                        }
                        for (i=0; i<len; i++)
                        {
                            fscanf(fh, "%i", &offset);
                            fp->cmpmask[i] = (BYTE)offset;
                        }
                    }
                    else
                        ret = -9;           /* insuff. memory */
                    break;
                default:
                    break;
                }
            }
        }
        fclose(fh);
    }
    else
        ret = -2;                           /* can't open file */
    return ret;
}

/*************************************************************************
** NAME:        Stop
** SYNOPSIS:    void Stop(void)
** DESCRIPTION: This function frees the filter elements
**                previously allocated by a call to Start().
** RETURNS:     void
** SEE ALSO:    Start
*************************************************************************/
static void Stop(void)
{
    FILT *fp = firstfilt;
    FILT *fp2;

    while (fp)
    {
        fp2 = fp;
        free(fp->andmask);
        free(fp->xormask);
        free(fp->cmpmask);
        fp = fp->next;
        free(fp2);
    }
    firstfilt = (FILT *)0;
}
