/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dpfuser.c
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/10/26
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPFUSER.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFUSER.C_V  $
**              
**                 Rev 1.0   26 Oct 1990 13:56:02   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFUSER.C_V   1.0   26 Oct 1990 13:56:02   etstjan  $";
#endif
#include <ctype.h>
#include "dpfinc.h"

static int ProcessEvent(DPEVENT Event);
static int FrFilterFtpUser(DPBUF *frp);
static int FrFilterNovellUser(DPBUF *frp);

DPFILT DpfUser = { "User", ProcessEvent, 0 };

static int DpfCmp(BYTE far *buf1, BYTE far *buf2, unsigned len);

static int DpfCmp(BYTE far *buf1, BYTE far *buf2, unsigned len)
{
    while (len && (*buf1==*buf2))
    {
        buf1++;
        buf2++;
        len--;
    }
    return len;
}

static int ProcessEvent(DPEVENT Event)
{
    DPBUF *pBuf;

    switch (Event)
    {
    case DPE_RECEIVEPKT:
        pBuf = DpReceivePkt();
        return (FrFilterFtpUser(pBuf) | FrFilterNovellUser(pBuf));
        break;
    }
    return 0;
}

/*************************************************************************
** NAME:        FrFilterUser
** SYNOPSIS:    int FrFilterUser(frp)
** DESCRIPTION: Filter function to filter Users and their Passwords
**                Currently detects NOVELL and FTP
** RETURNS:     void
** EXAMPLE:     wd_init(&dev,....,FrReadDat);
**              FrFilterFunc = FrFilterUser;
**              dev_enable(dev);
*************************************************************************/

static int FrFilterFtpUser(frp)
DPBUF *frp;
{
    int ret = 0;
    int segmoff;
    int datoff;
    unsigned int len;
    BYTE far *ptr;

    if ((*DpfIP.pProcessEventFunction)(DPE_RECEIVEPKT))
    {                                       /* DOD IP */
        if ((frp->pBuf+hdrinfo->DatOff)[9] == 6)
        {                                   /* TCP */
            segmoff = ((frp->pBuf+hdrinfo->DatOff)[0] & 0x0f) * 4;
            if (((frp->pBuf+hdrinfo->DatOff)[segmoff+2] == 0x00) &&
                ((frp->pBuf+hdrinfo->DatOff)[segmoff+3] == 0x15))
            {                               /* FTP dest port */
                len = ((frp->pBuf+hdrinfo->DatOff)[2] << 8) + (frp->pBuf+hdrinfo->DatOff)[3];
                datoff = ((frp->pBuf+hdrinfo->DatOff)[segmoff+12] >> 4) * 4;
                if (len > segmoff+datoff+4)
                {
                    ptr = (frp->pBuf+hdrinfo->DatOff) + segmoff + datoff;
                    if ((DpfCmp(ptr, "USER", 4) == 0) ||
                        (DpfCmp(ptr, "PASS", 4) == 0))
                        ret = -1;
                }
            }
        }
    }
    return ret;
}

static int FrFilterNovellUser(frp)
DPBUF *frp;
{
    int len = ((frp->pBuf+hdrinfo->DatOff)[2] << 8) + (frp->pBuf+hdrinfo->DatOff)[3];
    int userlen;
    int passlen;
    int i;
    int ret = 0;
    BYTE far *ptr = (frp->pBuf+hdrinfo->DatOff)+40;
    unsigned int type = ((frp->pBuf)[hdrinfo->TypOff] << 8) +
                         (frp->pBuf)[hdrinfo->TypOff+1];

    if ((*Dpf802.pProcessEventFunction)(DPE_RECEIVEPKT))
    {
        userlen = ptr[0];
        passlen = ptr[userlen+1];
        if (userlen && passlen && (userlen + passlen + 42 == len))
        {
            i = 0;
            while ((i<userlen) && isprint(ptr[1+i]))
                i++;
            if (i == userlen)
            {
                i = 0;
                while ((i<passlen) && isprint(ptr[userlen+2+i]))
                    i++;
                if (i == passlen)
                    ret = -1;
            }
        }
    }
    return ret;
}

