/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       ECHO.C
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1990/7/30
**
** DESCRIPTION: DP application file for the Echo daemon
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   ECHO.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/ECHO/VCS/ECHO.C_V  $
**              
**                 Rev 1.0   01 Feb 1991 15:14:14   etstjan
**              No explicit note
**              
**                 Rev 1.1   21 Nov 1990 14:40:48   etstjan
**              No explicit note
**              
**                 Rev 1.0   21 Nov 1990 13:18:28   etstjan
**              No explicit note
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/BAPS/ECHO/VCS/ECHO.C_V   1.0   01 Feb 1991 15:14:14   etstjan  $";
#endif
#include      <stdio.h>                /* for NULL                          */
#include      <string.h>
#include      <power3.h>               /* for POWER screen functions        */
#include      <beholder.h>


/* prototyping of static functions                                          */
static int  ProcessEvents(DPEVENT Event);
static void FreeTime(void);
static void EchoStart(void);           /* Echo application start            */
static void EchoStop(void);            /* Echo application stop             */
static void EchoShow(void);            /* Echo application show             */
static void EchoHide(void);            /* Echo application hide             */

#define MAXSIZE 1000

PWWIN *EchoWin;                        /* Echo messages window pointer      */

DPAPPS DpaEcho = {
    "Echo Daemon",                          /* Application name             */
    ProcessEvents,                          /* Event processing function    */
    0,                                      /* Status, must be 0            */
    DPE_FREETIME | DPE_START | DPE_SHOW | DPE_HIDE |
                   DPE_STOP | DPE_RESET,
    DPE_START | DPE_RESET,
    0,
    -1,
    0,
    0,
    0,
    0,                                      /* Count of active filters      */
    {0}                                     /* List of active Filters       */
    };

SOCKET              EchoSock;
BYTE                RecPacket[MAXSIZE];
USHORT              NrResp = 0;
USHORT              NrErr = 0;
int                 Visible = 0;
int                 Active = 0;

/**************************************************************
** NAME:        ProcessEvents
** SYNOPSIS:    static int ProcessEvents(DPEVENTS Event);
**
** DESCRIPTION: Processes dispatcher events.
**
** RETURNS:     0 -->   no error
**              else    error code
**************************************************************/
static int ProcessEvents(DPEVENT Event)
{
    int ret = 0;

    switch (Event) {
      case DPE_START:         EchoStart();          break;
      case DPE_STOP:          EchoStop();           break;
      case DPE_FREETIME:      FreeTime();           break;
      case DPE_RESET:         NrResp = NrErr = 0;   break;
      case DPE_SHOW:          EchoShow();           break;
      case DPE_HIDE:          EchoHide();           break;
      }
    return ret;
}

/**************************************************************
** NAME:        FreeTime
** SYNOPSIS:    static void FreeTime(void);
** 
** DESCRIPTION: Handles the reception of Ping Reply packets,
**              if waiting for a reply.
** RETURNS:  
**************************************************************/
static void FreeTime(void)
{
  struct sockaddr_in FromAddr = {
                     AF_INET };
  int                FromSize = sizeof(FromAddr);
  int                RetCode;

  if (Active) {
    while ((RetCode = recvfrom(EchoSock, RecPacket, MAXSIZE, 0,
                               (struct sockaddr *)&FromAddr, &FromSize)) > 0) {
      if (sendto(EchoSock, RecPacket, RetCode, 0,
                 (struct sockaddr *)&FromAddr, FromSize) < 0) 
        NrErr++;
      else 
        NrResp++;
      FromSize = sizeof(FromAddr);
      }
    if (RetCode != NOMESSAGE) {
      NrErr++;
      }
    if (Visible) {
      pw_cursor(EchoWin, 0, 16);
      pw_printf(EchoWin, "%5u", NrResp);
      pw_cursor(EchoWin, 1, 16);
      pw_printf(EchoWin, "%5u", NrErr);
      }
    }
}

/**************************************************************
** NAME:        EchoStart
** SYNOPSIS:    static void EchoStart(void);
**           
** DESCRIPTION: Starts the Echo daemon.
** RETURNS:  
**************************************************************/
static void EchoStart(void)
{
  struct sockaddr_in BindAdd;

  if ((EchoSock = socket(AF_INET, SOCK_DGRAM, 0)) == NULL) {
    NrErr++;
    return;
    }
  BindAdd.sin_family = AF_INET;
  BindAdd.sin_port = htons(0x7);
  BindAdd.sin_addr.s_addr = INADDR_ANY;
  if (bind(EchoSock, (struct sockaddr *)&BindAdd, sizeof(BindAdd)) != 0) {
    NrErr++;
    closesocket(EchoSock);
    return;
    }
  Active = 1;
}  

/**************************************************************
** NAME:        EchoStop
** SYNOPSIS:    static void EchoStop(void);
**           
** DESCRIPTION: Stops the Echo daemon.
** RETURNS:  
**************************************************************/
static void EchoStop(void)
{
  if (Active) {
    Active = 0;
    closesocket(EchoSock);
    }
}

/**************************************************************
** NAME:        EchoShow
** SYNOPSIS:    static void EchoShow(void);
**           
** DESCRIPTION: Starts displaying of the Echo daemon.
** RETURNS:  
**************************************************************/
static void EchoShow(void)
{
  if (!Visible) {
    if ((EchoWin = pw_open(15, 1, 2, 23, "Echo Daemon",
                           PWM_DEFAULT, PWW_NORMAL)) == NULL) {
      return;
      }
    pw_printf(EchoWin, "#Echo Requests:\n");
    pw_printf(EchoWin, "#Echo Errors:");
    Visible = 1;
    }
}

/**************************************************************
** NAME:        EchoHide
** SYNOPSIS:    static void EchoHide(void);
**           
** DESCRIPTION: Stops displaying of the Echo daemon.
** RETURNS:  
**************************************************************/
static void EchoHide(void)
{
  if (Visible) {
    Visible = 0;
    pw_close(EchoWin);
    }
}




