/********************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IPCODES.H
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       90/2/6
**
** DESCRIPTION: Return values of the IP library.
**
*********************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** CHANGER:     $Author:   etstjan  $
** WORKFILE:    $Workfile:   IPCODES.H  $
** LOGFILE:     $Logfile:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/IPCODES.H_V  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/IPCODES.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 11:41:16   etstjan
**              No explicit note
*********************************************************************/

/*=========================================================================*/
/* Definition of return codes  */

/***************************************************************************/
/* All functions */
#define NO_ERR           0      /* everything OK                      */
#define ILL_REQUEST      -300   /* illegal request                    */
#define NOT_FOUND        -301   /* searched or asked item not found   */
#define NO_PROTOC        -302   /* protocol not found                 */    
#define NO_PORT          -303   /* port not found                     */
#define DUMMYCODE        -304   /* just a dummy error code            */

/***************************************************************************/
/* All device drivers */
#define IF_DOWN          -310   /* requested interface in not alive */

/***************************************************************************/
/* Ethernet initialization return codes */
#define ETHINITERR       -10    /* error in initializing ethernet driver */

/***************************************************************************/
/* Initialization file processing errors */
#define ND0ERROR         -20   /* nd0 address not specified */
#define LO0ERROR         -21   /* lo0 address not specified */
#define VAL_ERROR        -22   /* illegal value specified */
#define ROUTE_ERROR      -23   /* route specification error */

/***************************************************************************/
/* UpdateReAss return codes */
#define REASS_COMPL      -40    /* reassembly is completed */

/***************************************************************************/
/* ProcessOptions return codes */
#define PACK_SEND        -41    /* packet send by process options */

/***************************************************************************/
/* IPReport input codes */

/* IPLIB return codes */

/* CipToByte return codes */
#define PARAMERR         -43    /* parameter problem */

/* ByteToCip return codes */
#define CHECKERR         -44    /* checksum error in received packet */
#define VERERR           -45    /* version number not correct */
#define HLENERR          -46    /* header longer than packet */

/* OptionsToCip return codes */
#define LENGTHERR        -47    /* option field to long */
#define OPTERR           -48    /* error in option      */

/* IPSendEther return codes */
#define ERRORETHER       -50    /* error in sending to ethernet */
#define ARPBUSY          -51    /* already an ARP req. for this address */

/* IPSend return codes */
#define NOT_ON_NET       -60    /* destination not on connected network */
#define NOT_REACHED      -61    /* no first hop for this destination */  
#define FRAG_NOT_ALL     -62    /* fragmentation was not allowed */
#define MMS_TOO_SMALL    -63    /* maximum message size too small */


/* Reporting codes */
#define   NOSPACE        -65    /* no space in buffers */
#define   TOOSHORT       -66    /* packet too short */
#define   DATASHORT      -67    /* not enough data in packet */
#define   NOREASSSPACE   -68    /* no space for reassembly */
#define   REASS_ERR      -69    /* error in reassembly procedure */
#define   REASSTIMEOUT   -70    /* reassembly timeout occured */
#define   ILL_ADDRESS    -71    /* packet not for this host */
#define   ROUTNOTALL     -73    /* routing of a packet was not allowed */
#define   ROUTFAIL       -74    /* failed to route a packet */            
#define   ROUTTIMEX      -75    /* time exceeded in routing a packet */
#define   ILLOPTION      -76    /* illegal option detected in packet */
#define   ERRSRCRT       -77    /* error in source route forwarding */
#define   NOFIRSTHOP     -78    /* no first hop for this destination */
#define   NOTONCONN      -79    /* not on connected network */
#define   ILLPROT        -80    /* illegal protocol on receive */   
#define   ILLBCAST       -81    /* broadcast, but not on link layer */
          /* ICMP errors */
#define   ICMPSHORT      -85    /* ICMP packet too short */
#define   ICMPCHERR      -86    /* ICMP checksum error */     
          /* UDP errors */
#define   UDPSHORT       -90    /* UDP packet too short */
#define   UDPCHERR       -91    /* UDP checksum error */
          /* socket handling errors */
#define   QUEUEFULL      -95    /* socket receive queue full */
          /* ARP errors */
#define   ARPSHORT       -100   /* ARP packet too short */
          /* unknown error report */
#define   UNKNOWN        -500   /* unknown error */

/*=========================================================================*/
/* Protocol constants */

/***************************************************************************/
/* IP protocol defines */
#define VERSION       4      /* current protocol version       */
#define MINMMS        576    /* minimum MMS for internet       */
#define TTL           30     /* default time to live           */
#define ICMPTOS       0      /* ICMP type of service           */      
#define UDPTOS        0      /* UDP type of service            */
#define RAWTOS        0      /* raw socket type of service     */
#define REASSTIME     90     /* reass. timeout value (seconds) */
#define ARPTIME       3600   /* ARP table timeout (seconds)    */
#define ARPRETRIES    5      /* # ARP solve retries            */
#define ARPRETRTIME   5      /* # seconds between ARP retries  */

/* ethernet types */
#ifdef BIG_ENDIAN
  #define ETHERIP     0x0800 /* ethernet type for an IP packet */
  #define ETHERARP    0x0806 /* ethernet type for an ARP packet*/
#endif

#ifdef LITTLE_ENDIAN
  #define ETHERIP     0x0008 /* ethernet type for an IP packet */
  #define ETHERARP    0x0608 /* ethernet type for an ARP packet*/
#endif

/* ARP opcodes */
#define ARPREQOP      1      /* ARP request opcode             */
#define ARPREPOP      2      /* ARP reply opcode               */

/***************************************************************************/
/* IP header option codes */
#define ENDOFLIST     0      /* End of Option List */
#define NOP           1      /* No Operation */
#define SECURITY      130    /* Security Option */
#define LOOSE         131    /* Loose Source and Record Route */
#define STRICT        137    /* Strict Source and Record Route */
#define RECORD        7      /* Record Route */
#define STREAM        136    /* Stream Identifier */
#define TIMESTAMP     68     /* Internet Timestamp */

/***************************************************************************/
/* ICMP type codes */
#define   ECHOREPLY   0                   /* echo reply                    */
#define   DSTUNRCH    3                   /* destination unreachable       */
#define   SRCQUENCH   4                   /* source quench                 */
#define   REDIRECT    5                   /* redirect                      */
#define   ECHO        8                   /* echo                          */
#define   TIMEX       11                  /* time exceeded                 */
#define   PARAMPROB   12                  /* parameter problem             */
#define   TIME        13                  /* timestamp message             */
#define   TIMEREPLY   14                  /* timestamp reply message       */
#define   INFOREQ     15                  /* information request           */
#define   INFOREPLY   16                  /* information reply             */
#define   AMREQ       17                  /* address mask request          */
#define   AMREPLY     18                  /* address mask reply            */
       
/* ICMP code codes */
/* destination unreachable */
#define   NETUNRCH    0                   /* net unreachable               */
#define   HOSTUNRCH   1                   /* host unreachable              */
#define   PROTUNRCH   2                   /* protocol unreachable          */
#define   PORTUNRCH   3                   /* port unreachable              */
#define   DFSET       4                   /* fragm. needed and DF set      */
#define   SRCFAIL     5                   /* source route failed           */

/* time exceeded */
#define   TTLEXCEED   0                   /* time to live exceeded         */
#define   REASEXCEED  1                   /* fragment reassembly execeeded */

/* parameter problem */
#define   PNTINDIC    0                   /* pointer indicated the error   */
#define   REQOPTMIS   1                   /* required option is missing    */

/* redirect */
#define   REDNET      0                   /* redirect for the network      */
#define   REDHOST     1                   /* redirect for the host         */
#define   REDNETTOS   2                   /* redirect for network & tos    */
#define   REDHOSTTOS  3                   /* redirect for host & tos       */
