.MODEL SMALL

.CODE
EXTRN _PktError:FAR             ; PktError(PktInt,Function,ErrorCode)

PcktName db 'PKT DRVR'
Function db 0

        even
        PUBLIC _PdsCheckDriver
_PdsCheckDriver PROC FAR
	push	bp
	mov	bp,sp
        push    ds
        push    di
        push    si

;	PktInt = 6

        mov     al, BYTE PTR [bp+6]     ;PktInt
	mov	ah, 35h
        int     21h                     ;Get vector in es:bx
        xor     ax, ax                  ;Return false
        or      bx, bx
        jz      NotEqual
        mov     di, bx                  ;es:di points to packet driver
        add     di, 3                   ;Skip jump instruction
        mov     si, offset PcktName
        mov     cx, cs
        mov     ds, cx
        assume  ds:nothing
        mov     cx, 4
        repz    cmpsw                   ;Repeat while equal
        jnz     NotEqual
        inc     ax                      ;Return true
NotEqual:
        pop     si
        pop     di
        pop     ds
	mov	sp, bp
	pop	bp
        ret
_PdsCheckDriver ENDP

        even
PktInterrupt PROC NEAR
        mov     Function, ah    ;Store function number
CallGate label byte
        int     7Eh
	jc      Error
        ret
Error:  
        xor     ax, ax
        mov	al, dh
	push	ax              ;Error code
        mov     al, Function
	push	ax
        mov     al, CallGate+1
	push	ax
	call	_PktError
	add	sp, 6
        mov     dx, ax          ;return code in dx
        stc                     ;Set carry flag
        ret	
PktInterrupt ENDP

CallPkt PROC    NEAR
        mov     CallGate+1, al
        call    PktInterrupt
        jc      CPExit
        xor     dx, dx          ;No Error
CPExit: mov     ax, dx          ;Return code in AX
        ret
CallPkt ENDP

	PUBLIC	_PdsGetAddress
_PdsGetAddress	PROC FAR
	push	bp
	mov	bp,sp
        push    di

;	PktInt = 6
;	Handle = 8
;	fpBuf = 10
;	BufSize = 14

        mov     al, BYTE PTR [bp+6]     ;PktInt
        mov     bx, WORD PTR [bp+8]     ;Handle
	les	di, DWORD PTR [bp+14]	;BufSize
        mov     cx, es:[di]
	les	di, DWORD PTR [bp+10]	;fpBuf
	mov	ah, 6
        call    CallPkt
        jc      GAExit
	les	di, DWORD PTR [bp+14]	;BufSize
        mov     es:[di], cx
GAExit: pop     di
	mov	sp, bp
	pop	bp
        ret
_PdsGetAddress	ENDP


	PUBLIC	_PdsResetInterface
_PdsResetInterface	PROC FAR
	push	bp
	mov	bp,sp

;	PktInt = 6
;	Handle = 8

	mov	al, BYTE PTR [bp+6]	;PktInt
        mov     bx, WORD PTR [bp+8]     ;Handle
	mov	ah, 7                   ;Reset Interface.
        call    CallPkt
	mov	sp, bp
	pop	bp
        ret
_PdsResetInterface	ENDP

	PUBLIC	_PdsSetRcvMode
_PdsSetRcvMode	PROC FAR
	push	bp
	mov	bp,sp

;	PktInt = 6
;	Handle = 8
;	Mode = 10

	mov	al, BYTE PTR [bp+6]	;PktInt
	mov	bx, WORD PTR [bp+8]     ;Handle
	mov	cx, WORD PTR [bp+10]	;Mode
	mov	ah, 20
        call    CallPkt
	mov	sp, bp
	pop	bp
        ret
_PdsSetRcvMode	ENDP

	PUBLIC	_PdsSendPkt
_PdsSendPkt	PROC FAR
	push	bp
	mov	bp,sp
        push    ds

;	PktInt = 6
;	fpBuf = 8
;	BufSize = 12

	mov	al, BYTE PTR [bp+6]	;PktInt
	lds	si, DWORD PTR [bp+8]	;fpBuf
	mov	cx, WORD PTR [bp+12]	;BufSize
	mov	ah, 4
        call    CallPkt
        pop     ds
	mov	sp, bp
	pop	bp
        ret
_PdsSendPkt	ENDP

PKTINFO    STRUC
iVersion   DW      ?
iType      DW      ?
iName      DD      ?
iClass     DB      ?
iNumber    DB      ?
iInstalled DB      ?
PKTINFO    ENDS

	PUBLIC	_PdsGetInfo
_PdsGetInfo	PROC FAR
	push	bp
	mov	bp,sp
        push    ds
        push    di
        push    si

;	PktInt = 6
;	pInfo = 8

	mov	ax, 01ffh
        xor     bx, bx                  ;Handle
        mov     cl, BYTE PTR [bp+6]     ;PktInt
        mov     CallGate+1, cl
        call    PktInterrupt
        jc      IExit

        les     di, DWORD PTR [bp+8]    ;Address of structure to fill
        cld                    
        push    ax                      ;Save installed flag
        mov     ax, bx                  ;Version
        stosw
        mov     ax, dx                  ;Type
        stosw                           
        mov     ax, si                  ;Offset of name
        stosw
        mov     ax, ds                  ;Segment of name
        stosw
        mov     al, ch                  ;Class
        stosb
        mov     al, cl                  ;Number
        stosb
        pop     ax                      ;Installed
        stosb
        xor     ax, ax                  ;No errors getting info
IExit:	pop     si
        pop     di
        pop     ds
        mov	sp,bp
	pop	bp
	ret	
_PdsGetInfo	ENDP

	PUBLIC	_PdsAccessType
_PdsAccessType	PROC FAR
	push	bp
	mov	bp,sp
	push	di
	push	si
        push    ds

;	PktInt = 6
;       Class = 8
;       Type = 10
;       Number = 12
;	fpType = 14
;	Typelen = 18
;	fpRecFunc = 20
;	pHandle = 24

	mov	dh, BYTE PTR [bp+6]	;PktInt
        mov     al, BYTE PTR [bp+8]     ;Class
        mov     bx, WORD PTR [bp+10]    ;Type
        mov     dl, BYTE PTR [bp+12]    ;Number
        lds     si, DWORD PTR [bp+14]   ;Pointer to type
        mov     cx, WORD PTR [bp+18]    ;TypeLen
        les     di, DWORD PTR [bp+20]   ;Receive function
        mov	ah, 2
        mov     CallGate+1, dh
        call    PktInterrupt
        jc      AExit
        les     di, DWORD PTR [bp+24]   ;place to store Handle
        stosw                           ;Store handle
        xor     dx, dx                  ;No errors creating new access type
AExit:  mov     ax, dx
        pop     ds
	pop	si
	pop	di
	mov	sp,bp
	pop	bp
	ret	
_PdsAccessType	ENDP

        PUBLIC  _PdsReleaseType
_PdsReleaseType	PROC FAR
	push	bp
	mov	bp, sp
;	PktInt = 6
;	Handle = 8
	mov	al, BYTE PTR [bp+6]	;PktInt
	mov	bx, WORD PTR [bp+8]	;Handle
        mov     ah, 3
        call    CallPkt
	mov	sp, bp
	pop	bp
	ret	
_PdsReleaseType	ENDP

        PUBLIC  _PdsTerminate
_PdsTerminate	PROC FAR
	push	bp
	mov	bp, sp
;	PktInt = 6
;	Handle = 8
	mov	al, BYTE PTR [bp+6]	;PktInt
	mov	bx, WORD PTR [bp+8]	;Handle
        mov     ah, 5
        call    CallPkt
	mov	sp, bp
	pop	bp
	ret	
_PdsTerminate   ENDP

	PUBLIC	_PdsGetStatistics
_PdsGetStatistics	PROC FAR
	push	bp
	mov	bp,sp
        push    si
        push    ds

;	PktInt = 6
;	Handle = 8
;       ppStat = 10

        mov	al, BYTE PTR [bp+6]	;PktInt
        mov	bx, WORD PTR [bp+8]	;Handle
	mov	ah, 24
        call    CallPkt
        jc      SExit
        les     bx, DWORD PTR [bp+10]   ;Place to store pointer
        mov     es:[bx],si       
        mov     es:[bx+2],ds
SExit:  pop     ds
        pop     si
        mov	sp, bp
	pop	bp
	ret	
_PdsGetStatistics	ENDP

	PUBLIC	_PdsResetStatistics
_PdsResetStatistics	PROC FAR
	push	bp
	mov	bp,sp
        push    di
        push    si
        push    ds

;	PktInt = 6
;	Handle = 8

        mov	al, BYTE PTR [bp+6]	;PktInt
        mov	bx, WORD PTR [bp+8]	;Handle
	mov	ah, 24
        call    CallPkt
        jc      RSExit
        mov     ax, ds
        mov     es, ax
        mov     di, si
        mov     cx, 14
        xor     ax, ax
        cld
        cli
        rep     stosw
        sti
RSExit: pop     ds
        pop     si
        pop     di
        mov	sp, bp
	pop	bp
	ret	
_PdsResetStatistics	ENDP
END          
