/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       ml.c
**     SYSTEM   NAME:       BEHOLDER
**     ORIGINAL AUTHOR(S):  Dirk Wisse
**     VERSION  NUMBER:     1
**     CREATION DATE:       1991/1/9
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   ML.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/ML/VCS/ML.C_V  $
**              
**                 Rev 1.0   01 Feb 1991 09:37:42   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/CPROG/BEHOLDER/ML/VCS/ML.C_V   1.0   01 Feb 1991 09:37:42   etstjan  $";
#endif

                                        
#include <dnpap.h>  /* Definition of DNPAP standard types */
#include <dp.h>     /* Definition of Dispatcher Packet Buffer DPBUF */
#include <string.h> /* Prototype for memcpy */ 

#ifndef NULL
#define NULL    ((void *)0)
#endif

typedef struct _ADDR
{
    int     Type;
    char    Addr [6];
}   ADDR;

           
/**************************************************************
** NAME:        MLGetLength         
** SYNOPSIS:    WORD   MLGetLength (DPBUF *BufPtr)
** DESCRIPTION: Length of MAC packet.
**              Finds the length of the MAC packet from the
**              buffer pointed to by BufPtr.
** RETURNS:     word length of data.
**************************************************************/
WORD    MLGetLength (DPBUF *BufPtr)
{
    return (BufPtr->Size);
}

/**************************************************************
** NAME:        MLGetBeginData         
** SYNOPSIS:    BYTE   *MLGetBeginData (DPBUF *BufPtr)
** DESCRIPTION: Begin of MAC data.
**              Finds the begin of the MAC data from the
**              buffer pointed to by BufPtr.
** RETURNS:     pointer to begin of data.
**************************************************************/
BYTE   *MLGetBeginData (DPBUF *BufPtr)
{
    return (BufPtr->pBuf + 14);    
}

/**************************************************************
** NAME:        MLGetLengthData         
** SYNOPSIS:    WORD   MLGetLengthData (DPBUF *BufPtr)
** DESCRIPTION: Length of MAC data.
**              Finds the length of the MAC data from the
**              buffer pointed to by BufPtr.
** RETURNS:     word length of data.
**************************************************************/
WORD    MLGetLengthData (DPBUF *BufPtr)
{
    return (BufPtr->Size - 14);
}

/**************************************************************
** NAME:        MLGetBeginHeader         
** SYNOPSIS:    BYTE   *MLGetBeginHeader (DPBUF *BufPtr)
** DESCRIPTION: Begin of MAC header.
**              Finds the begin of the MAC header from the
**              buffer pointed to by BufPtr.
** RETURNS:     NULL -> no header
**              else    pointer to begin of header.
**************************************************************/
BYTE   *MLGetBeginHeader (DPBUF *BufPtr)
{
    return (BufPtr->pBuf);
}

/**************************************************************
** NAME:        MLGetLengthHeader         
** SYNOPSIS:    WORD   MLGetLengthHeader (DPBUF *BufPtr)
** DESCRIPTION: Length of MAC header.
**              Finds the length of the MAC header from the
**              buffer pointed to by BufPtr.
** RETURNS:     word length of header.
**************************************************************/
WORD    MLGetLengthHeader (DPBUF *BufPtr)
{
    return 14;
}


/**************************************************************
** NAME:        MLGetBeginTrailer         
** SYNOPSIS:    BYTE   *MLGetBeginTrailer (DPBUF *BufPtr)
** DESCRIPTION: Begin of MAC trailer.
**              Finds the begin of the MAC trailer from the
**              buffer pointed to by BufPtr.
** RETURNS:     NULL -> no trailer.
**              else    pointer to begin of trailer.
**************************************************************/
BYTE   *MLGetBeginTrailer (DPBUF *BufPtr)
{
    return NULL;
}

/**************************************************************
** NAME:        MLGetLengthTrailer         
** SYNOPSIS:    WORD   MLGetLengthTrailer (DPBUF *BufPtr)
** DESCRIPTION: Length of MAC trailer.
**              Finds the length of the MAC trailer from the
**              buffer pointed to by BufPtr.
** RETURNS:     word length of trailer.
**************************************************************/
WORD    MLGetLengthTrailer (DPBUF *BufPtr)
{
    return 0;
}


/**************************************************************
** NAME:        MLGetTypeDevice        
** SYNOPSIS:    WORD    MLGetTypeDevice (DPBUF *BufPtr)
** DESCRIPTION: Type of MAC device.
**              Can be used to determine the type of the
**              device if several devices can be monitored.
** RETURNS:     word device type.
**************************************************************/
WORD    MLGetTypeDevice (DPBUF *BufPtr)
{
    return 0;
}

/**************************************************************
** NAME:        MLGetNumberDevice        
** SYNOPSIS:    WORD    MLGetNumberDevice (DPBUF *BufPtr)
** DESCRIPTION: Number of MAC device.
**              Can be used to determine the number of the
**              device if several devices of one MAC type
**              have been installed.
** RETURNS:     word device number.
**************************************************************/
WORD    MLGetNumberDevice (DPBUF *BufPtr)
{
    return 0;
}

/**************************************************************
** NAME:        MLGetProtocol      
** SYNOPSIS:    WORD    MLGetProtocol (DPBUF *BufPtr)
** DESCRIPTION: Type of MAC protocol.
**              Can be used to determine protocol type.
** RETURNS:     word protocol type.
**************************************************************/
WORD    MLGetProtocol (DPBUF *BufPtr)
{
    WORD    Type;

    Type = *(BufPtr->pBuf + 12);
    Type <<= 8;
    Type |= *(BufPtr->pBuf + 13);
    return (Type > 1514) ? Type : 0;  
}


/**************************************************************
** NAME:        MLGetLengthAddress        
** SYNOPSIS:    WORD   MLGetLengthAddress (DPBUF *BufPtr)
** DESCRIPTION: Length of address.
**              Finds the length of an address from the buffer
**              pointed to by BufPtr.
** RETURNS:     word length of address.
**************************************************************/
WORD    MLGetLengthAddress (DPBUF *BufPtr)
{
    return 6;
}

/**************************************************************
** NAME:        MLGetSrcAddress        
** SYNOPSIS:    void    MLGetSrcAddress
**                              (DPBUF *BufPtr, BYTE *Address)
** DESCRIPTION: Copy of source address.
** RETURNS:     void.
**************************************************************/
void    MLGetSrcAddress (DPBUF *BufPtr, BYTE *Address)
{
    memcpy (Address, BufPtr->pBuf + 6, 6);
}


/**************************************************************
** NAME:        MLGetDstAddress        
** SYNOPSIS:    void    MLGetDstAddress
**                              (DPBUF *BufPtr, BYTE *Address)
** DESCRIPTION: Copy of destination address.
** RETURNS:     void.
**************************************************************/
void    MLGetDstAddress (DPBUF *BufPtr, BYTE *Address)
{
    memcpy (Address, BufPtr->pBuf, 6);
}
