/*
|	FILE: FUNCTS.H
|
|	This header file contains the function prototypes for
|	all of the functions in Until.
|
|	This module contains copyrighted source code for part the 
|	UNTIL Language Materials. 
|
|	Written by:
|		Norman E. Smith, CDP
|		Copyright 1992, 1994
|		All Rights Reserved
|
|	Right to use, copy, and modify this code is granted
|	for personal non-commercial use, provided that this
|	copyright disclosure remains on ALL copies. Any other
|	use, reproduction, or distribution is covered in the
|	License Agreement with the Until Language Maeterials
|	documentation and in the file LICENSE.TXT.
*/
/********************************************************
|               FUNCTION PROTOTYPES
*/
void recurse();
void str_return(void);
void return_errno(void);
void seal(void);
void unseal(void);
void write_crypt(struct encrypt_key*,char *);
void read_crypt(struct encrypt_key*,char *);
char U_crypt(struct encrypt_key*,char);
void crypt_string(struct encrypt_key*,char*);
void set_crypt_key(struct encrypt_key*, char*);
void base_fn(char*, char*, char*);
void fence(void);
void call_forget();
void do_align();
void query();
void query_terminal();
void outer(void);
void cls();
void help();
void outer();
void cold(void);
void warm();
struct NameField *CreateNFA(char*);
void Create(void);
void Compile_colon(void);
void Compile_vocabulary(void);
void Compile_definitions(void);
void Compile_variable(void);
void Compile_constant(void);
void pushsp(long);
long popsp(void);
void pushrs(long);
long poprs(void);
void do_vocabulary(void);
void do_definitions(void);
void do_variable(void);
void do_constant(void);
void do_primitive(void);
/* void do_colon(struct DictHeader *); */
void do_colon();
void do_colon_2(void);
void do_word(struct DictHeader *);
void drop(void);
void word(void);
void prim_token(void);
void build_pfa_list(void);
int  prim_find(void);
void minus_find(void);
void to_null(void);
void n_to_count();
void counted_to_null(char *,char *);
void null_to_counted(char *, char*);
void build_primitive(char*, void(*)(void));
void build_iprim(char*, void(*)(void));
void exec_word(void);
void execute(void);
void type(void);
void fetch(void);
void cfetch(void);
void store(void);
void cstore(void);
void minus_rot(void);
void multiply(void);
void divide(void);
void prim_dup(void);
void two_dup(void);
void swap(void);
void rot(void);
void plus(void);
void minus(void);
void less_than(void);
void less_than_equal(void);
void greater_than(void);
void greater_than_equal(void);
void equals(void);
void u_less_than(void);
void u_greater_than(void);
void dot(void);
struct DictHeader* set_WA(char*);
void key(void);
void emit(void);
void immediate(void);
void words(void);
void zero(void);
void one(void);
void two(void);
void three(void);
void dump(void);
void prompt(void);
void bye(void);
void abort_F(void);
void abort_quote(void);
void read_next_line(void);
void read_file_line(void);
void file_stdin(void);
void file_stdout(void);
void file_stderr(void);
char *read_stdin(void);
char *read_include(void);
char *read_binary(void);
void finclude(void);
void close_include(void);
void open_stdin(void);
long open_source(char*,long, char*);
void number(void);
void cr(void);
void allot(void);
void do_comma(void);
void do_c_comma(void);
void base_number(void);
void make_prims(void);
void display_word(void);
void cr(void);
void dot_s(void);
void tick(void);
void depth(void);
void addr_pad(void);
void addr_tib(void);
void to_in(void);
void count(void);
void next_word(void);
void do_allot(void);
void pfa_list_addr(void);
void pfa_offset_value(void);
void comma_offset_value(void);
void number_tib(void);
void dot_paren(void);
void parens(void);
void backslash(void);
void flush_pfa_list(long);
void semi(void);
void normal_semi();
void does_semi();
void rfetch(void);
void to_r(void);
void r_from(void);
void zero_less(void);
void zero_greater(void);
void zero_equal(void);
void one_plus(void);
void one_minus(void);
void two_plus(void);
void two_minus(void);
void two_divide(void);
void star_slash_mod(void);
void slash_mod(void);
void base_prim(void);
void decimal(void);
void hex(void);
void binary(void);
void query_dup(void);
void absolute(void);
void cmove(void);
void cmove_up(void);
void fill(void);
void prim_forth();
void forth_83(void);
void here(void);
void literal(void);
void do_literal(void);
void do_lit(void);
void U_load(void);
void fload(void);
void prim_max(void);
void prim_min(void);
void mod(void);
void negate(void);
void not(void);
void or(void);
void over(void);
void pick(void);
void roll(void);
void space(void);
void spaces(void);
void span_prim(void);
void state_prim(void);
void u_dot(void);
void um_star(void);
void um_slash_mod(void);
void xor(void);
void dot_quote(void);
void star_slash(void);
void plus_store(void);
void quote(void);
void f_exit(void);
void force_exit(void);
void prim_expect(void);
void do_cstring(void);
void do_malloc();
void do_realloc();
void do_free();
void do_do(void);
void do_zero_do(void);
void do_loop(void);
void do_plus_loop(void);
void do_until(void);
void do_i(void);
void do_j(void);
void do_k(void);
void zero_bran(void);
void branch(void);
void leave(void);
void Compile_dot_quote(void);
void Compile_quote(void);
void Compile_abort_quote(void);
void Compile_if(void);
void Compile_then(void);
void Compile_else(void);
void Compile_case(void);
void Compile_endcase(void);
void Compile_of(void);
void Compile_endof(void);
void do_of(void);
void do_case(void);
void do_endcase(void);
void Compile_do(void);
void Compile_for(void);
void Compile_loop(void);
void Compile_plus_loop(void);
void Compile_begin(void);
void Compile_until(void);
void Compile_while(void);
void Compile_repeat(void);
void Compile_i(void);
void Compile_j(void);
void Compile_k(void);
void prim_printf();
void prim_sprintf();
void prim_fprintf();
void prim_printf_f();
void prim_sprintf_f();
void prim_fprintf_f();
void file_fnsplit(void);
void file_fopen(void);
void file_fclose(void);
void file_fgetc(void);
void file_fgets(void);
void file_fputc(void);
void file_fputs(void);
void file_fcr(void);
void file_fflush(void);
void file_ftell(void);
void file_fseek(void);
void file_fread(void);
void file_fwrite(void);
void file_fputline(void);
void ft_read(void);
void ft_text(void);
void ft_update(void);
void ft_new_update(void);
void ft_append_update(void);
void ft_write(void);
void ft_append(void);
void ft_binary(void);
void prim_ftime(void);
void to_counted(void);
void startup(int,char**);
long do_autoload(char*,long);
void builds(void);
void Compile_does(void);
void do_does(void);
void Compile_do_does(void);
void left_bracket(void);
void right_bracket(void);
void bracket_tick(void);
void bracket_compile(void);
void do_compile(void);
void compile(void);
void less_sharp(void);
void sharp(void);
void sharp_greater(void);
void sharp_s(void);
void hold(void);
void sign(void);
void ascii(void);
void forget(void);
void and(void);
void d_plus(void);
void d_minus(void);
void d_less(void);
void dnegate(void);
void edit(void);
void end_shell(void);
void U_system(void);
void gdot_s(void);
void do_smudge(void);
void smudge(char *);
void hide(char *);
void minus_trailing(void);
void xargc(void);
void xargv(void);
void do_system(void);
void do_shell(void);
void type_file(void);
void prim_getenv(void);
void do_dir(void);
void do_create(void);
void v_word(void);
void Compile_string(void);
void set_str_return(void);
void set_str_type(void);
void C_strncmp(void);
void C_strcmp(void);
void C_atol(void);
void C_strcat(void);
void C_strncat(void);
void C_strcpy(void);
void C_strncpy(void);
void C_strlen(void);
void C_strupr(void);
void prints(void);
void c_type(void);
void center(char*);
void make_initial_vocs(void);
void do_definitions(void);
void do_vocabulary(void);
void Compile_definitions(void);
void Compile_vocabulary(void);
int  thread_search(struct DictHeader*, char*, long);
void dot_vocs(void);
void set_show_stack();
void set_show_copy();
void dot_bin();
void Until(char *);

#ifdef VECTORED_IO
void exec_verbatim();
void exec_display();
void exec_center();
void exec_dot_s();
void exec_g_dots();
void exec_dot();
void exec_dot_quote();
void exec_type();
void exec_prints();
void exec_emit();
void exec_cr();
void exec_key();
void exec_space();
void exec_spaces();
void exec_query_terminal();
void addr_cr_vect();
void addr_verbatim_vect();
void addr_display_vect();
void addr_center_vect();
void addr_dot_quote_vect();
void addr_type_vect();
void addr_dot_vect();
void addr_prints_vect();
void addr_printf_vect();
void addr_emit_vect();
void addr_space_vect();
void addr_spaces_vect();
void addr_key_vect();
void addr_query_terminal_vect();
#endif

#ifndef __TURBOC__
void strupr(char*);
#endif

#ifdef FLOAT_POINT
double fpop();
void fpush(double);
void float_init();
#endif

#ifdef SENGINE
void sengine_init();
void sengine_make_prims();
void sengine();
void nest_open();
void push_sgml_file();
void nest_close();
void next_token();
char next_char();
char skip_leading_ws();
int parse_char(char);
void store_char(char);
void close_tag();
void close_attrib();
void collect_attrib(char);
void collect_attrib_value();
void exec_cmd(char*);
void oi_init();
void XX_read_next_line();
void X_read_next_line();
void push_new_line_flag();
void push_fmt_flag();
void viewer_make_prims();
#endif

#ifdef ANSI_CONSOLE
void scr_cls();
void scr_home();
void scr_erase_eol();
void scr_normal_video();
void scr_bold_video();
void scr_gotoxy();
#endif
