0 .IF 

The definitions in this file are intended for use in developing
CFORTH compilable programs in an ANS Forth compatible interpretive
environment.

The definitions are not necessarily sufficient to compile
CFORTH programs, but they are a good start!

Tom Almy
8/94
.THEN

( This first group tends to be needed by any implementation )
( Convert compiler directives into NOOPs )
: MSDOS  DROP ;
: MSDOSEXE  2DROP ;
: ROMABLE  2DROP DROP ;
: IN/OUT  2DROP ;
: PRIMITIVE  ;
: CSEG  ;
: DSEG  ;
: ALIGNDATA  ;
: INITIALIZE  ;
: I80186 ;
: I80386 ;

( some more compiler functions that get aliased )
: H:  [COMPILE] : ;
: SEPSSEG?  FALSE ;
: SEPDSEG?  FALSE ;  ( maybe??)
: ALIGNED?  FALSE ;

( CS=DS [maybe??] so these default to datasegment operations)
: CS:  ; IMMEDIATE
: CS:TYPE  TYPE ;

( defining words for arrays and tables )
: ARRAY  CREATE  CELLS ALLOT  DOES>  SWAP CELLS + ;
: CARRAY  CREATE  ALLOT  DOES>  + ;
: TABLE  CREATE DOES> SWAP CELLS + @ ;
: CTABLE  CREATE DOES> + C@ ;

( defining word for string constants )
: SCONSTANT  CREATE  [CHAR] " WORD C@ CHAR+ ALLOT ;

( compile strings into dictionary )
: ,"  [CHAR]  PARSE SWAP OVER HERE SWAP MOVE  ALLOT ;

( IMMEDIATE versions of HEX and DECIMAL )
: [HEX]  HEX ; IMMEDIATE
: [DECIMAL]  DECIMAL ; IMMEDIATE

( Not typically defined )
: CELL- 2 - ;
: <-  SWAP ! ;
: C<-  SWAP C! ;
: CTRL  BL WORD 1+ C@ 31 AND ;
: [CTRL] CTRL POSTPONE LITERAL ; IMMEDIATE
: ',  ' , ;
: ?LEAVE  POSTPONE IF POSTPONE LEAVE POSTPONE THEN ; IMMEDIATE
: RANGE  OVER + SWAP ;
: CSET  DUP C@ ROT OR C<- ;
: ?CTEST  C@ AND 0<> ;
: CRESET  DUP C@ ROT INVERT AND C<- ;
: CTOGGLE  DUP C@ ROT XOR C<- ;
: -ROT  ROT ROT ;
: U/  0 SWAP  UM/MOD  NIP ;
: ><  256 M* OR ;
