unit ECase;

{ Implements an UPCASE function which includes the international
  characters in the IBM-PC character set.  If you include this unit
  and still wish to use the built-in upcase function, refer to it
  as system.upcase().
}
interface

function UpCase(ch: char): char;

implementation

function UpCase(ch: char): Char;

begin
     if ch <= #127 then 
          UpCase := system.upcase(ch)
     else
     case ch of
     #129: UpCase := #154;  { umlat-u }
     #132: Upcase := #142;  { umlat-a }
     #134: UpCase := #143;  { a with a circle over it :-}
     #135: UpCase := #128;  { c with a tail :-}
     #145: UpCase := #146;  { AE, as in Aetna }
     #148: UpCase := #153;  { umlat-o }
     #164: UpCase := #165;  { n with a tilde }
     else UpCase := ch;
     end;  { case }
end; {function UpCase}
end. {unit}
