(* ******************************************************************** *)
(* ComHex - Dump a COM file into a HEX file.                            *)
(* Author - Victor Lee , Queen's University, Kingston, Ontario, CANADA  *)
(*                       Network id -  VIC at QUCDN                     *)
(* Date   - 1986 Feb 12                                                 *)
(* Note :   See HexCom to convert  HEX file into COM file.              *)
(* ******************************************************************** *)
Program ComHex ;
type  blocks = array [1..128] of char ;
      S2 = string[2] ;
 var
    i : byte ;
    ComName,HexName : string[14] ;
    FN    : string[8] ;
    abyte : byte ;
    Afile : file of byte ;
    Bfile : Text ;
   count,Rcount : integer ;
label  exit ;

 function hex(num:byte) : S2;
 var digit :byte ;
      hex1 : char ;
    begin (* hex *)
    digit := num and $0F ;
    if digit > 9 then digit := digit + 7 ;
    hex1 := chr($30 + digit) ;
    digit := (num and $F0) div $10 ;
    if digit > 9 then digit := digit + 7 ;
    hex := concat(chr($30+digit),hex1);
    end;


    Begin (* hex Dump *)
    Writeln('Enter Name of COM File to Dump into HEX file ');
    Readln(FN);
    ComName := FN + '.COM' ;
    HexName := FN + '.HEX' ;
    Assign (Afile,ComName);
    Assign (Bfile,HexName);
    Reset(Afile);
    Rewrite(Bfile);
    count := 0 ;
    Rcount := 0 ;
    Writeln('Converting File: ',ComName,' file size =',FileSize(Afile));
    Write(' 32 bytes make a 64 byte Record . Record count = ');
    While True Do
      Begin (* write a line *)
      For i := 1 to $20 do
         Begin (* dump file *)
         if Eof(Afile) then goto exit;
         read(Afile,abyte);
         count := count + 1 ;
    (*   write(hex(abyte));   *)
         write(Bfile,hex(abyte));
         End;
      Writeln(Bfile);
      Rcount := Rcount + 1 ;
      Write(RCount ,'  ');
      End ; (* write a line *)
  exit :
   Close(Bfile) ;
   Writeln('Number of 64 byte records =',Rcount +1);
   Writeln('New file ',HexName,' created.  File size is ',count*2);
   End. (* hex Dump *)
