* Program ...: Julcal.PRG
* Author ....: Clay Carley
* Date ......: July 1, 1985
* Version ...: dBASE II, any version
* Note(s)....: Converts a Julian date passed as a numeric memory
*              variable named (jul:date) and returns a
*              character memory variable named (cdate) in
*              calendar format (MM/DD/YY).
*
STORE INT( jul:date / 365.26 ) + 1 TO year
STORE jul:date + INT( 395.25 - 365.25 * year ) TO day
IF INT( year / 4 ) * 4 = year
   STORE 1 TO leapday
ELSE
   STORE 2 TO leapday
ENDIF
IF day > ( 91 - leapday )
   STORE day + leapday TO day
ENDIF
STORE INT( day / 30.57 ) TO month
STORE day - INT( 30.57 * month ) TO day
IF month > 12
   STORE 1 TO month
   STORE year + 1 TO year
ENDIF
IF month < 10
   STORE 1 TO monlen
ELSE
   STORE 2 TO monlen
ENDIF
IF day < 10
   STORE 1 TO daylen
ELSE
   STORE 2 TO daylen
ENDIF
STORE year - 1900 TO year
STORE STR( month, monlen ) + '/' + STR( day, daylen ) + '/' + STR( year ,2 ) TO       cdate
RELEASE day, daylen, leapday, month, monlen, year
RETURN
* EOP Julcal.PRG