* Program..: Err_hist.PRG
* Author...: Jeffrey Bersin
* Date.....: October 1, 1985
* Version..: dBASE III, The Developer's Release
* Note(s)..: Program to create an error history report
*            when a dBASE III error has occurred during
*            command file operation.
*
SET DOHISTORY OFF
? "An error has occured!  Please stand by..."
SET CONSOLE OFF
* ---Turn off ON ERROR, in case an error occurs in this program.
ON ERROR
* ---Setup alternate file name. 
err_file = "E" + REPLICATE("0",2-LEN(LTRIM(STR(DAY(DATE()),2))));
               + LTRIM(STR(DAY(DATE()),2)) + SUBSTR(TIME(),1,2);
               + SUBSTR(TIME(),4,2) + SUBSTR(TIME(),7,1);
               + ".ERR"

* ---Set and turn on Error File.
SET ALTERNATE TO &err_file
SET ALTERNATE ON
* ---Display program status.
? DATE()
? TIME()
?
? REPLICATE( "=", 50 )
? "History listing"
? REPLICATE( "=", 50 )
LIST HISTORY
? REPLICATE( "=", 50 )
? "Status Listing"
? REPLICATE( "=", 50 )
LIST STATUS
? REPLICATE( "=", 50 )
? "Memory Listing"
? REPLICATE( "=", 50 )
? "BOF()= " 
?? BOF()
? "EOF()= "
?? EOF() 
? "RECNO()= "
?? RECNO()
SET SAFETY OFF    
* ---Saves the name of the Err_File.
SAVE TO Temp      
* ---Releases only memory variables created by this routine.
RELEASE ALL       
LIST MEMORY 
? REPLICATE("=",50)
* ---Brings back the err_file memory variable.
RESTORE FROM Temp
SET SAFETY ON
* ---Reset alternate file.
SET ALTERNATE OFF
SET ALTERNATE TO
SET CONSOLE ON
ON ERROR DO Err_hist
? "Error filename is " + CHR( 16 ) + err_file
SET DOHISTORY ON
* ---Pass control back to the calling routine.  This is where
* ---you want to decide what to do next.  The RETURN statement
* ---will return control to the statement immediately following 
* ---the one that intiated the error. 
RETURN
* EOP Err_hist.PRG