/*	standard i/o header file for c86
*/

#ifndef	_stdioh	

#ifdef _C86_BIG
#define NULL (0L)
#else
#define NULL 0
#endif

#define EOF (-1)	/* standard end of file */
#define EOS '\0'	/* standard end of string */
#define AREAD 0		/* ascii read */
#define AWRITE 1	/* ascii write */
#define AUPDATE 2	/* ascii update (take care with this one) */
#define BREAD 4		/* binary update */
#define BWRITE 5	/* binary write */
#define BUPDATE 6	/* binary update */

#define SEEK_CUR 1	/* seek rel to current */
#define SEEK_END 2	/* seek rel to end */
#define SEEK_SET 0	/* seek absolute */

/*	This is the max no. of files that the run-time allows
	you to have open at one time. The operating system
	also imposes additional constraints.
*/
#define SYS_OPEN  32

typedef char FILE;

#define getchar() fgetc(stdin)
#define getc(x) fgetc(x)
#define putchar(x) fputc(x,stdout)
#define putc(x,y) fputc(x,y)
#define ungetch(c) ungetc(c,stdin)

extern FILE *stdin, *stdout, *stderr;

extern FILE *fopen(), *freopen();
extern long ltell(), lseek(), ftell(), fseek();
extern char *gets(), *fgets();

#endif

#define _stdioh

/*	end of standard header file
*/
