#ifndef DLL_H
#define DLL_H
//DOC_BEGIN
//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.

#include "btypes.h"
#include "action.h"

template <class T>
class dll_node_C {
public:
  bt_C<dll_node_C> next,prev;
  T item;
};


template <class T>
class dll_C {
public:

  bt_C< dll_node_C<T> > f_ele,l_ele;
  bt_C< dll_node_C<T> > c_ele;
  int_B n_elements;
  int_B position;
  action_B action;
  void set_action (action_B& action);
  int  doit();//execute accion in the current element
  int  doit_all();//execute accion in all the elements
  int  is_out(void); //test if the pointer is out of the list
  void out(void); //set the pointer out of the list
  int get_location(void); //return the number of the current element
								  //return 0 if the pointer is out of the list
  int set_location(int location); //move the pointer to the location
  int size(void); // return the number of elements of the list
  int first(void); //move to the first element
  int last(void); //move to the last element
  int next(void); //move to the next element
  int prev(void); //move to the previous element
  int insert_r(T& item); // insert to the right of the curren element
								 // if is_out() insert as the first element
  int insert_l(T& item); // insert to the left of the current element
								 // if is_out() insert as the last element
  int del(void); // remove the current element
  void del_all(void); //remove all the elements
  T& item(void); //acces the item at the current element
					  //you must be in a valid position !is_out()
  dll_C();
};

//DOC_END
template<class T>
dll_C<T>::dll_C ()
{
	if (n_elements.is_void()) {
		n_elements.create();
		position.create();
		action.create();
		n_elements()=0;
		position()=0;
	}
}


template<class T>
void dll_C<T>::set_action (action_B& action_param)
{
	dll_C<T>::action=action_param;
}

template<class T>
int  dll_C<T>::doit()
{
	if (position()) {
		if (action().start())if (action().doaction(&item()))
		return  action().finish();
	}
	return 0;
}

template<class T>
int  dll_C<T>::doit_all()
{
	int result =0;
	out();
	result=action().start();
	while(next() && result)  result = result && action().doaction(&item());
	result=result && action().finish();
	return result;
}

template<class T>
int dll_C<T>::get_location(void)
{
  return position();
}

template<class T>
int dll_C<T>::size(void)
{
  return n_elements();
}

template<class T>
int dll_C<T>::first(void)
{
   bt_C< dll_node_C<T> >  sec1;
   if(n_elements()>0) {
      sec1.secure(c_ele);
      c_ele=f_ele;
      return position()=1;
   }
   c_ele.forget();
   return position()=0;
}


template<class T>
int dll_C<T>::last(void)
{
   bt_C< dll_node_C<T> >  sec1;
   if(n_elements()>0) {
      sec1.secure(c_ele);
      c_ele=l_ele;
      return position()=n_elements();
   }
   c_ele.forget();
   return position()= 0;
}

template<class T>
int dll_C<T>::next(void)
{
   bt_C< dll_node_C<T> >  sec1;
   if (!position())
      return first();
   if (position()!=n_elements()) {
      sec1.secure(c_ele);
      c_ele=c_ele().next;
      return ++position();
   }
   c_ele.forget();
   return position()=0;
}

template<class T>
int dll_C<T>::prev(void)
{
   bt_C< dll_node_C<T> >  sec1;
   if (!position())
      return last();
   if (position()!=1) {
      sec1.secure(c_ele);
      c_ele=c_ele().prev;
      return --position();
   }
   c_ele.forget();
   return position()=0;
}

template<class T>
int dll_C<T>::insert_r(T& item)
{
   bt_C< dll_node_C<T> >  new_node,sec1;
   new_node.create();
   new_node().item=item;
   n_elements()++;

   if (l_ele.is_void())
      f_ele=l_ele=new_node;
   else {
      if (c_ele.is_void()) {
          new_node().next=f_ele;
          f_ele().prev=new_node;
          sec1.secure(f_ele);
          f_ele=new_node;
      }

      else {
          new_node().next=c_ele().next;
          if (!c_ele().next.is_void()) {
             sec1.secure(c_ele().next().prev);
             c_ele().next().prev=new_node;
          }
          sec1.secure(c_ele().next);
          c_ele().next=new_node;
          new_node().prev=c_ele;
          if (c_ele==l_ele) {
             sec1.secure(l_ele);
             l_ele=new_node;
          }
      }
   }
   return 1;
}


template<class T>
int dll_C<T>::insert_l(T& item)
{
   bt_C< dll_node_C<T> >  new_node,sec1;
   new_node.create();
   new_node().item=item;

   n_elements()++;

   if (f_ele.is_void())
      f_ele=l_ele=new_node;
   else {
      if (c_ele.is_void()) {
         new_node().prev=l_ele;
         sec1.secure(l_ele().next);
         l_ele().next=new_node;
         sec1.secure(l_ele);
         l_ele=new_node;
      }

      else {
         new_node().prev=c_ele().prev;
         if (!c_ele().prev.is_void()) {
             sec1.secure(c_ele().prev().next);
             c_ele().prev().next=new_node;
         }
         sec1.secure(c_ele().prev);
         c_ele().prev=new_node;
         new_node().next=c_ele;
         if (c_ele==f_ele) {
            sec1.secure(f_ele);
            f_ele=new_node;
         }
         position()++;
      }
   }
   return 1;
}



template<class T>
int dll_C<T>::del(void)
{
   bt_C< dll_node_C<T> >  sec1,sec_cur;
   sec_cur.secure(c_ele);
   if (!position()) return 0;
   if (position()==1) {
      sec1.secure(f_ele);
      f_ele=c_ele().next;
   }
   else {
      sec1.secure(c_ele().prev().next);
      c_ele().prev().next=c_ele().next;
   }
   if (position()==n_elements()){
      sec1.secure(l_ele);
      l_ele=c_ele().prev;
   }
   else {
      sec1.secure(c_ele().next().prev);
      c_ele().next().prev=c_ele().prev;
   }

   if (f_ele.is_void()) {
      position()=n_elements()=0;
      sec_cur.release();
      return 1;
   }

   if (c_ele().next.is_void())   {
      c_ele=c_ele().prev;
      position()=0;
   }
   else
      c_ele=c_ele().next;
   n_elements()--;
   sec_cur.release();
   return 1;
}

template<class T>
void dll_C<T>::del_all()
{
   c_ele.forget();
   l_ele.secure();
   l_ele.forget();
   f_ele.forget();
   n_elements.create();
   position.create();
   action.create();
   n_elements()=0;
   position()=0;
}

template<class T>
T& dll_C<T>::item()
{
   return c_ele().item;
}

template<class T>
int dll_C<T>::set_location(int location)
{
   if (location<0 || location>n_elements()) return 0;
   if (location==0) {
    c_ele.forget();
    position()=location;
    return 1;
   }

   if (location>position())
      while (location!=position())
    next();

   if (location<position())
      while (location!=position())
    prev();

   return 1;
}

template<class T>
int dll_C<T>::is_out()
{
   return !position();
}

template<class T>
void dll_C<T>::out()
{
   bt_C< dll_node_C<T> >  sec1;
   sec1.secure(c_ele);
   position()=0;
   c_ele.forget();
}


#endif
