#ifndef BTREE_H
#define BTREE_H
//DOC_BEGIN
//
//(C) Copyright 1995, Diego Ernesto Malpica Chauvet.
//              All rights reserved.

#include "key.h"
#include "storage.h"
#include "dllk.h"
#include "stack.h"
//DOC_END


class btree_item_C{
public:
	key_B key;
	u_long_B p;
	int compare_k(btree_item_C btree_item, int key);
	void clear(void);
	btree_item_C(void);
};

typedef bt_C<btree_item_C> btree_item_B;
//-------------------------------------------------------------
//------------------------------------------------------------
class btree_page_C{
public:
	u_long_B p0;
	bt_C< dllk_C< btree_item_B > > items;
	void  clear();
	btree_page_C();
};

typedef bt_C <btree_page_C> btree_page_B;

//DOC_BEGIN

class btree_C:public storage_C{
//btree_C support transcations, you should consider that the operations of
//btree_C consume an extra transaction level to make its operations atomics
//this is independent of your actual transaction
public:
	u_char_B level;   //this is the level used of the storage for the btree
							//you can change at any time to another level and you will
							//be using a diferent tree

	//the prefix of the key indicate a diferent idependent zone of the tree
	//this zone is independent for all the operations
	int first_key(key_B& key);//get the first key of the zone
	int last_key(key_B& key); //get the last key of the zone
	int prev_key(key_B& key); //get the prev key of the zone you must be in
									  //a valid position of the zone
	int next_key(key_B& key); //get the next key of the zone you must be in
									  //a valid position of the zone
	int find_key(key_B& key); //find a key in the zone return 1 if it had a match
									  //return 2 if it not have and exact match
	int find_exact_key(key_B& key); //find and exact match if it does'nt returns
											  //0, it uses the recpos pos in the key to
											  //find a especific object, this is important
											  //in the case that you are'nt using unic keys

	int add_key(key_B& key,int trans_param=-1); //add a key to the btree
	int del_key(key_B& key,int trans_param=-1); //delete a key of the btree

//                               Initialization
//you must initialize your btree before you use it whit

	void init(int data_size=512,int orden=10,int level=0);
//	this metod initialize the storage_C class with a datasize, the btree_C
// with an order orden, and set the level for the initial btree to 0
// all the others params of the btree_C and storage_C take the defaul values
// gived in the next two metods

	void init_btree(int orden=3, int level=0);
	void init_storage(int data_size=512,int default_level=1,int levels=5,
							int trans=10);
// you can use this two metods for a more especific initialization of the
// storage_C and btree_C class, you must use both.

//DOC_END

protected:
	enum btree_E {ADDKEY_TRANS=10,DELKEY_TRANS};
	int undo(storage_trans_control_B& trans_param);
	int commit(storage_trans_control_B& trans_param);

private:
	int_B orden;
	bt_C< stack_C<u_long_B> >  stack;
	int add_key_nt(key_B& key);
	int del_key_nt(key_B& key);
	int is_leaf(btree_page_B& btree_page);
	int find(key_B& key,
				 btree_page_B &page_a,
				 u_long_B& l_page_a,
				 int key_opt=1,
				 int aprox=0);
	int findb(key_B& key,
				 btree_page_B &page_a,
				 u_long_B& l_page_a,
				 int key_opt=1,
				 int aprox=0);
	void disp(btree_page_B& page, u_long_B& l_page);
	void disp(key_B& key);
//DOC_BEGIN
};

typedef bt_C<btree_C> btree_B; //type declaration for a handler

//DOC_END

#endif
