/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: stktst.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program for the stack class.
*
* $Id: stktst.cpp 1.1 1994/03/09 12:19:51 kjb release $
*
****************************************************************************/

#include "debug.h"
#include "stack.hpp"
#include <iostream.h>
#include <malloc.h>
#include <stdlib.h>

class MyNode : public ListNode {
	int		_id;
public:
			MyNode(int id) 	{ _id = id; };
			int id(void)	{ return _id; };
	virtual	~MyNode();
	};

MyNode::~MyNode()
{
//	cout << "Deleting " << _id << endl;
}

Stack<MyNode>	s;

void dumpStack(Stack<MyNode>& s)
{
	ListIterator<MyNode>	i;

	if (!s.isEmpty()) {

		// Dump some details about the stack

		cout << "Top Item: " << s.top()->id() << endl;

		cout << "Contents of stack (" << s.numberOfItems() << " items):";
		cout << endl << "    ";

		for (i = (List<MyNode>&)s; i; i++)
			cout << i.node()->id() << " ";
		}
	else
		cout << "Empty stack (" << s.numberOfItems() << ")";

	cout << endl << endl;
}

void main(void)
{
	int		i;
	MyNode	*n;

	cout << "Memory at start: " << coreleft() << " bytes\n";

	// Create a stack of 10 nodes.

	for (i = 0; i < 10; i++) {
		n = new MyNode(i);
		s.push(n);
		}

	cout << "Memory after creating stack: " << coreleft() << " bytes\n";

	dumpStack(s);

	// Kill the stack and display it

	s.empty();
	dumpStack(s);

	// Create a stack of 10 nodes.

	for (i = 0; i < 10; i++) {
		n = new MyNode(i);
		s.push(n);
		}

	dumpStack(s);

	// Remove all the nodes from the stack with pop()

	while ((n = s.pop()) != NULL) {
		cout << "Popped " << n->id() << endl;
		delete n;
		}

	dumpStack(s);

	cout << "Memory at end: " << coreleft() << " bytes\n";
}
