/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: qtst.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program for the queue class.
*
* $Id: qtst.cpp 1.1 1994/03/09 12:19:51 kjb release $
*
****************************************************************************/

#include "debug.h"
#include "queue.hpp"
#include <iostream.h>
#include <malloc.h>
#include <stdlib.h>

class MyNode : public ListNode {
	int		_id;
public:
			MyNode(int id) 	{ _id = id; };
			int id(void)	{ return _id; };
	virtual	~MyNode();
	};

MyNode::~MyNode()
{
//	cout << "Deleting " << _id << endl;
}

Queue<MyNode>	q;

void dumpQueue(Queue<MyNode>& q)
{
	ListIterator<MyNode>	i;

	if (!q.isEmpty()) {

		// Dump some details about the queue

		cout << "First Item: " << q.peek()->id() << endl;

		cout << "Contents of queue (" << q.numberOfItems() << " items):";
		cout << endl << "    ";

		for (i = (List<MyNode>&)q; i; i++)
			cout << i.node()->id() << " ";
		}
	else
		cout << "Empty queue (" << q.numberOfItems() << ")";

	cout << endl << endl;
}

void main(void)
{
	int		i;
	MyNode	*n;

	cout << "Memory at start: " << coreleft() << " bytes\n";

	// Create a queue of 10 nodes.

	for (i = 0; i < 10; i++) {
		n = new MyNode(i);
		q.put(n);
		}

	cout << "Memory after creating queue: " << coreleft() << " bytes\n";

	dumpQueue(q);

	// Kill the queue and display it

	q.empty();
	dumpQueue(q);

	// Create a queue of 10 nodes.

	for (i = 0; i < 10; i++) {
		n = new MyNode(i);
		q.put(n);
		}

	dumpQueue(q);

	// Remove all the nodes from the queue with get()

	while ((n = q.get()) != NULL) {
		cout << "Removed " << n->id() << endl;
		delete n;
		}

	dumpQueue(q);

	cout << "Memory at end: " << coreleft() << " bytes\n";
}
