/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: memtst.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program for the MemStack class.
*
* $Id: memtst.cpp 1.1 1994/03/09 12:19:51 kjb release $
*
****************************************************************************/

#include "memmgr.hpp"
#include <malloc.h>
#include <iostream.h>

class MyNode {
	int		_id;
	char	stuff[255];

public:
			MyNode(int id) 	{ _id = id; };
			int id(void)	{ return _id; };
	};

void DoLocal(MemStack& mem)
{
	MyNode	*n;

	MemMarker marker(mem);

	for (int i = 0; i < 100; i++)
		n = new(mem) MyNode(i);

	cout << "Memory at end of locals: " << coreleft() << " bytes\n";
}

void main(void)
{
	MyNode	*n;

	cout << "Memory at start: " << coreleft() << " bytes\n";

	MemStack* mem = new MemStack;	// Allocate a memory stack

	cout << "Memory after creating stack: " << coreleft() << " bytes\n";

	for (int i = 0; i < 10; i++)
		n = new(*mem) MyNode(i);

	cout << "Memory after doing allocation: " << coreleft() << " bytes\n";

	DoLocal(*mem);

	cout << "Memory after doing locals: " << coreleft() << " bytes\n";

	for (i = 0; i < 20; i++)
		n = new(*mem) MyNode(i);

	cout << "Memory before end: " << coreleft() << " bytes\n";

	delete mem;

	cout << "Memory at end: " << coreleft() << " bytes\n";
}
