/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: memmgr.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Implementation for the Memory management classes.
*
* $Id: memmgr.cpp 1.1 1994/03/09 12:18:03 kjb release $
*
****************************************************************************/

#include "memmgr.hpp"
#include <stdlib.h>

/*---------------------------- Implementation -----------------------------*/

bool MemStack::allocatePoolBlock()
/****************************************************************************
*
* Function:		MemStack::allocatePoolBlock
* Returns:		True if block was allocated, false on failure
*
* Description:	Allocates a new large pool block of the specified size,
*				and links it onto the list of allocated pool blocks.
*
****************************************************************************/
{
	BlockList *temp = (BlockList*)malloc(sizeof(BlockList) + blockSize);
	if (temp) {
		temp->next = curBlock;
		curBlock = temp;
		blockCount++;
		return true;
		}
	else
		return false;
}

void MemStack::freeFrom(uint block)
/****************************************************************************
*
* Function:		MemStack::freeFrom
* Parameters:	block	- Pool block number to start freeing from
*
* Description:	Free's all the pool blocks from 'block' to the current
*				maximum.
*
****************************************************************************/
{
	PRECONDITION(block <= blockCount);
	while (block < blockCount) {
		BlockList *temp = curBlock;
		curBlock = temp->next;
		free(temp);
		blockCount--;
		}
}

void *MemStack::allocate(size_t size)
/****************************************************************************
*
* Function:		MemStack::allocate
* Parameters:	size	- Size of memory block to allocate
* Returns:		Pointer to the allocated block, or NULL if allocation failed
*
* Description:	Attempts to allocate space for the requested block from
*				the current memory pool. If this fails, we attempt to
*				allocate another memory pool and allocate the memory
*				from there.
*
****************************************************************************/
{
	PRECONDITION(size != 0);
	if (size > blockSize - curLoc) {
		if (allocatePoolBlock())
			curLoc = 0;
		else
			return NULL;
		}
	void *temp = poolStart() + curLoc;
	curLoc += size;
	return temp;
}
