/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: point.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Implementation for integer point class. All we do here
*				is provide routines for displaying the contents of a
*				vector on a stream.
*
* $Id: point.cpp 1.1 1994/03/10 11:50:56 kjb release $
*
****************************************************************************/

#include "point.hpp"

ostream& operator << (ostream& o,const Point& p)
/****************************************************************************
*
* Function:		operator <<
* Parameters:	o	- Stream to send data to
*				p	- Point to display
* Returns:		Stream to send data to.
*
* Description:	Dumps the contents of a point on a stream.
*
****************************************************************************/
{
	return	o << '(' << p.x << ',' << p.y << ')';
}
