/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tstcstk.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Test program for the contiguous stack class.
*
* $Id: tstcstk.cpp 1.1 1994/03/09 12:19:55 kjb release $
*
****************************************************************************/

#include "debug.h"
#include "cstack.hpp"
#include <iostream.h>
#include <malloc.h>
#include <stdlib.h>

void dumpStats(CStack<long>& stack)
{
	cout << (stack.isEmpty() ? "Empty stack\n" :
			(stack.isFull() ? "Full stack\n" : ""));
	cout << "Number of items: " << stack.numberOfItems() << endl;
}

void main(void)
{
	CStack<long>	stack(10);
	long			i;

	dumpStats(stack);

	for (i = 0; i < 10; i++) {
		stack.push(i);
		dumpStats(stack);
		}

	cout << "Top element: " << stack.top() << endl;
	cout << "3rd element: " << stack.element(3) << endl;

	for (i = 0; i < 10; i++) {
		cout << stack.pop() << ", ";
		}
	cout << endl;

	dumpStats(stack);

	for (i = 0; i < 10; i++) {
		stack.push(i);
		dumpStats(stack);
		}

	cout << "Popped with popn: " << stack.popn(10) << endl;

	dumpStats(stack);

	for (i = 0; i < 10; i++) {
		stack.push(i);
		dumpStats(stack);
		}

	stack.empty();
	dumpStats(stack);
}
