/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*                           All rights reserved.
*
* Filename:		$RCSfile: recttst.cpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 2.1
* Environment:	any
*
* Description:	Test program for the rectangle class.
*
* $Id: recttst.cpp 1.1 1992/07/06 23:07:06 kjb Exp $
*
****************************************************************************/

#include "debug.h"
#include "rect.hpp"
#include "ztimer.h"

void checkEmpty(Rect& r,char *name)
{
	cout << name;
	if (r.isEmpty())
		cout << " is empty" << endl;
	else
		cout << " is not empty" << endl;
}

void main(void)
{
	Rect	r1,r2(10,20,30,40),r3;
	Point	p1(15,35);

	cout << "p1: " << p1 << endl;
	cout << "r1: " << r1 << endl;
	cout << "r2: " << r2 << endl;

	checkEmpty(r1,"r1");
	checkEmpty(r2,"r2");

	if (r2.includes(p1))
		cout << "r2 include point p1" << endl;

	if (!r2.includes(0,0))
		cout << "r2 does not include (0,0)" << endl;

	if (!r1.intersect(r2))
		cout << "r1 and r2 do not intersect" << endl;

	r3 = r1 + r2;
	cout << "r3: " << r3 << endl;
	if (r2.intersect(r3))
		cout << "r2 and r3 intersect" << endl;

	r3 = r3 - r2;
	cout << "r2: " << r2 << endl;
	cout << "r3: " << r3 << endl;

	cout << "r2.moveTo(35,67): " << r2.moveTo(35,67) << endl;
}
