/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: techlib.hpp $
* Version:		$Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	General header file for the Techniques Class library.
*
* $Id: techlib.hpp 1.1 1994/03/09 12:17:58 kjb release $
*
****************************************************************************/

#ifndef	__TECHLIB_HPP
#define	__TECHLIB_HPP

#ifndef	__DEBUG_H
#include "debug.h"
#endif

/*--------------------------- Inline Functions ----------------------------*/

//---------------------------------------------------------------------------
// Set of C++ template functions to replace the MIN,MAX,ABS and RANGE macros
// in the "debug.h" header file.
//---------------------------------------------------------------------------

template <class T> inline T min(T a,T b)
{
	return MIN(a,b);
}

template <class T> inline T max(T a,T b)
{
	return MAX(a,b);
}

template <class T> inline bool range(T min,T v,T max)
{
	return RANGE(min,v,max);
}

//---------------------------------------------------------------------------
// Set of debugging macros used by the library. If the debug flag is
// set, they are turned on depending on the setting of the flag. If DEBUG
// is set to 2, all checks are turned on, if DEBUG is set to 1, only the
// pre-conditions are enabled. If DEBUG is 0 or undefined, no checks are
// peformed.
//---------------------------------------------------------------------------

void _TECH_checkFail(char *msg,char *cond,char *file,int line);

#undef	PRECONDITION
#undef	CHECK

#ifdef	DEBUG
#       define  PRE(x)  x
#       define  PRECONDITION(p)                                     \
		if (!(p)) _TECH_checkFail(									\
			"Precondition failed: '%s', file %s, line %d\n",		\
			#p, __FILE__, __LINE__)
#if		DEBUG > 1
#       define  CHK(x)  x
#		define	CHECK(p)											\
		if (!(p)) _TECH_checkFail(									\
			"Check failed: '%s', file %s, line %d\n",				\
			#p, __FILE__, __LINE__)
#else
#       define  CHK(x)
#		define	CHECK(p)		((void)0)
#endif
#else
#		define	PRECONDITION(p)	((void)0)
#		define	CHECK(p)		((void)0)
#       define  PRE(x)
#       define  CHK(x)
#endif

#endif	// __TECHLIB_HPP

