/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: queue.hpp $
* Version:      $Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Header file for a queue class made of objects linked in
*				a singly linked list.
*
* $Id: queue.hpp 1.1 1994/03/09 12:17:58 kjb release $
*
****************************************************************************/

#ifndef	__QUEUE_HPP
#define	__QUEUE_HPP

#ifndef	__LIST_HPP
#include "list.hpp"
#endif

/*--------------------------- Class Definition ----------------------------*/

//---------------------------------------------------------------------------
// The Queue class is an abstraction of the list class to provide operations
// normally performed on a queue data structure. Internally it is just a
// linked list, so anything placed on the list MUST be derived from
// ListNode.
//---------------------------------------------------------------------------

class GenQueue : private GenList {
protected:
	ListNode	*tail;		// Pointer to tail node of queue

public:
			// Constructor
			GenQueue() : GenList()	{ tail = head; };

			// Method to examine the next item waiting in the queue
			ListNode* peek() const	{ return peekHead(); };

			// Method to add an item to the queue
			void put(ListNode* node);

			// Method to remove the next item waiting in the queue
			ListNode* get();

			// Empties the queue by destroying all nodes
			void empty()
				{ GenList::empty(); tail = head; };

			// Returns the number of items in the list
			ulong numberOfItems() const
				{ return GenList::numberOfItems(); };

			// Returns true if the list is empty
			bool isEmpty() const
				{ return GenList::isEmpty(); };
	};

//---------------------------------------------------------------------------
// Template wrapper class for declaring Type Safe linked queues.
//---------------------------------------------------------------------------

template <class T> class Queue : public GenQueue {
public:
			T* peek() const
				{ return (T*)GenQueue::peek(); };
			T* get()
				{ return (T*)GenQueue::get(); };
	};

/*------------------------ Inline member functions ------------------------*/

inline void GenQueue::put(ListNode* node)
/****************************************************************************
*
* Function:		GenQueue::put
* Parameters:	node	- Node to add to the queue
*
* Description:	Adds the node to the queue by tacking it onto the end of
*				the list.
*
****************************************************************************/
{
	addAfter(node,tail);		// Add to the tail of the list
	tail = node;				// Maintain tail pointer
}

inline ListNode* GenQueue::get()
/****************************************************************************
*
* Function:		GenQueue::get
* Returns:		Pointer to the item removed from the queue.
*
****************************************************************************/
{
	if (count == 1)
		tail = head;			// Maintain tail pointer
	return removeFromHead();
}

#endif	// __QUEUE_HPP
