/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:     $RCSfile: error.cpp $
* Version:      $Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Module to implement default error handling.
*
* $Id: error.cpp 1.1 1994/03/09 12:17:58 kjb release $
*
****************************************************************************/

#include "error.hpp"
#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

/*--------------------------- Global Variables ----------------------------*/

// Pointer to the currently installed error handler

void	(*errorHandler)(int err) = defaultErrorHandler;

/*---------------------------- Implementation -----------------------------*/

void defaultErrorHandler(int err)
{
	cerr << "TECH: ";

	switch (err) {
		case STK_UNDERFLOW:
			cerr << "Stack underflow!\n";
			break;
		case STK_OVERFLOW:
			cerr << "Stack overflow!\n";
			break;
		case STR_LENGTHERR:
			cerr << "Exceeded " << UINT_MAX << " character string limit\n";
			break;
		default:
			cerr << "Unknown internal error!\n";
		}
	exit(EXIT_FAILURE);
}

void _TECH_checkFail(char *msg,char *cond,char *file,int line)
{
	fprintf(stderr,msg,cond,file,line);
	exit(EXIT_FAILURE);
}
