/****************************************************************************
*
*						  Techniques Class Library
*
*                   Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*
* Filename:     $RCSfile: deque.hpp $
* Version:      $Revision: 1.1 $
*
* Language:		C++ 3.0
* Environment:	any
*
* Description:	Header file for a double ended queue class made of objects
*				linked in a doubly linked list.
*
* $Id: deque.hpp 1.1 1994/03/09 12:17:52 kjb release $
*
****************************************************************************/

#ifndef	__DEQUE_HPP
#define	__DEQUE_HPP

#ifndef	__DLIST_HPP
#include "dlist.hpp"
#endif

/*--------------------------- Class Definition ----------------------------*/

//---------------------------------------------------------------------------
// The Deque class is an abstraction of the dlist class to provide operations
// normally performed on a double ended queue data structure. Internally it
// is just a doubly linked list, so anything placed on the list MUST be
// derived from DListNode. By default items are added to the left of the
// deque and removed from the right of the deque.
//---------------------------------------------------------------------------

class GenDeque : private GenDList {
public:
			// Methods to examine the left or right items in the deque
			DListNode* peek()		{ return peekHead(); };
			DListNode* peekLeft()	{ return peekHead(); };
			DListNode* peekRight()	{ return peekTail(); };

			// Methods to add an item to the deque
			void put(DListNode* node)		{ addToTail(node); };
			void putLeft(DListNode* node)	{ addToHead(node); };
			void putRight(DListNode* node)	{ addToTail(node); };

			// Methods to remove items from the deque
			DListNode* get()		{ return removeFromHead(); };
			DListNode* getLeft()	{ return removeFromHead(); };
			DListNode* getRight()	{ return removeFromTail(); };

			// Empties the entire list by destroying all nodes
			void empty()	{ GenDList::empty(); };

			// Returns the number of items in the list
			ulong numberOfItems()	{ return GenDList::numberOfItems(); };

			// Returns true if the list is empty
			bool isEmpty()	{ return GenDList::isEmpty(); };
	};

//---------------------------------------------------------------------------
// Template wrapper class for declaring Type Safe linked queues.
//---------------------------------------------------------------------------

template <class T> class Deque : public GenDeque {
public:
			T* peek()
				{ return (T*)GenDeque::peek(); };
			T* peekLeft()
				{ return (T*)GenDeque::peekLeft(); };
			T* peekRight()
				{ return (T*)GenDeque::peekRight(); };
			T* get()
				{ return (T*)GenDeque::get(); };
			T* getLeft()
				{ return (T*)GenDeque::getLeft(); };
			T* getRight()
				{ return (T*)GenDeque::getRight(); };
	};

#endif	// __DEQUE_HPP
