#include "screen.h"

ScreenSet* pScreenSet;

// This function initialise system not for all possible modes.
// To use another regime or mode - add corresponding block
ScreenSet::ScreenSet(int gdriver, int gmode)
    {
    icon_types[0] = loc(0, 0);
    icon_types[1] = loc(7, 3);            // TEXT size of icons
    icon_types[2] = loc(3, 1);
    icon_types[3] = loc(15, 5);

    int maxX = getmaxx() + 1;
    int maxY = getmaxy() + 1;

    cell_height = maxY / 25;
    if(maxX == 640)             // To use system with low resolution add
	log2cell_width = 3;     // corresponding operator.
    else
        log2cell_width = 4;

    cell_width  = 1 << log2cell_width;

    ICON_PIXELS_1 = loc(cell_width * 7, cell_height * 3);
    ICON_PIXELS_2 = loc(cell_width * 3, cell_height);
    ICON_PIXELS_3 = loc(cell_width * 15, cell_height * 5);

    standart_width =   cell_width;  // Char dimentions, not connected with
    standart_height =  cell_width;  // cells. Used as default for screen
    sub_interval    = cell_width + 4;  // output.

    g_driver = gdriver; g_mode = gmode;
    }
//////////////////////////
int* ScreenSet::get_cells(rect cur_rect)
    {
    int* cells = new int[25 * 80];
    int cells_num = 0;
    for(int y = cur_rect.origin.Y; y < cur_rect.corner.Y;
        y += pScreenSet->cell_height)
	for(int x = cur_rect.origin.X; x < cur_rect.corner.X;
	    x += pScreenSet->cell_width)
	    {
	    cells[cells_num] = y / pScreenSet->cell_height * 80
	        + (x >> pScreenSet->log2cell_width);
	    cells_num++;
	    }

    cells[cells_num] = -1;

    return cells;
    }
//////////////////////////
