#include "prn_rec.h"
#include <alloc.h>

FIELD_LIST::FIELD_LIST()
    {
    total_fields = used_fields = 0;
    field_list = NULL;
    }
/////////////////////////////
FIELD_LIST::~FIELD_LIST()
    {
    for(int i = 0; i < used_fields; i++)
	delete field_list[i];
    delete field_list;
    }
////////////////////////////
void FIELD_LIST::add(FIELD_LAYOUT* field, int number)
    {
    used_fields++;
    if(used_fields > total_fields)
	field_list = (FIELD_LAYOUT**)realloc(field_list,
	   (total_fields += ALLOCATION_STEP) * sizeof(FIELD_LAYOUT*));
    for(int i = used_fields; i > number; i--)
	field_list[i] = field_list[i - 1];
    field_list[number] = field;
    }
////////////////////////////
FIELD_LAYOUT* FIELD_LIST::remove_field(int number)
    {
    if(number > used_fields)
	return 0;
    FIELD_LAYOUT* temp = field_list[number];
    for(int i = number; i < used_fields; i++)
	field_list[i] = field_list[i + 1];
    used_fields--;
    if(total_fields - used_fields > 2 * ALLOCATION_STEP)
	field_list = (FIELD_LAYOUT**)realloc(field_list,
	    (total_fields -= ALLOCATION_STEP) * sizeof(FIELD_LAYOUT*));
    return temp;
    }
//////////////////////////////
ADD_LIST::ADD_LIST()
    {
    total_add = used_add = 0;
    add_list = NULL;
    }
/////////////////////////////
ADD_LIST::~ADD_LIST()
    {
    for(int i = 0; i < used_add; i++)
	delete add_list[i];
    delete add_list;
    }
////////////////////////////
void ADD_LIST::add(ADDINFO_LAYOUT* add, int number)
    {
    used_add++;
    if(used_add > total_add)
	add_list = (ADDINFO_LAYOUT**)realloc(add_list,
	   (total_add += ALLOCATION_STEP) * sizeof(ADDINFO_LAYOUT*));
    for(int i = used_add; i > number; i--)
	add_list[i] = add_list[i - 1];
    add_list[number] = add;
    }
/////////////////////////////
ADDINFO_LAYOUT* ADD_LIST::remove_add(int number)
    {
    if(number > used_add)
	return 0;
    ADDINFO_LAYOUT* temp = add_list[number];
    for(int i = number; i < used_add; i++)
	add_list[i] = add_list[i + 1];
    used_add--;
    if(total_add - used_add > 2 * ALLOCATION_STEP)
	add_list = (ADDINFO_LAYOUT**)realloc(add_list,
	    (total_add -= ALLOCATION_STEP) * sizeof(ADDINFO_LAYOUT*));
    return temp;
    }
//////////////////////////////
RECORD_LAYOUT::RECORD_LAYOUT() : FIELD_LIST(), ADD_LIST()
    {
    }