#include "meter.h"
#include "khbgi.h"
#include "patterns.h"

void Meter::show_meter(rect r, int attr, int bak, uchar* pat)
    {
    bar(r, attr, bak, pat);
    }
/////////////////////////
void Meter::show(loc pos, int len, int direction, int cursor, int pat,
              BORDERS type)
    {
    loc corner = !direction ? loc(pos.X + len, pos.Y + 1)
                           : loc(pos.X + 2, pos.Y + len);
    rect r = screenRect(rect(pos, corner));

    r.corner -= loc(2, 2);
    show_meter(r, (int)pColorSet->colors.ATTR_COLOR,
        (int)pColorSet->colors.FILL_COLOR, (uchar*)::pattern[pat]);
    r.corner += loc(2, 2);

    Carcase c;
    c.show(type, r);

    rect curs = !direction ? rect(pos.X + cursor, pos.Y,
                                 pos.X + cursor + 2, pos.Y + 1)
                          : rect(pos.X, pos.Y + cursor,
			         pos.X + 2, pos.Y + cursor + 1);
    rect r1 = screenRect(curs);
    r1.symmexpand(loc(-1, -1));
    Element e(r1, NO_ELEMENT, BUTTON_BORDER, pat, 1);
    e.show();
    }
////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Meter m;
    m.show(loc(10, 10), 40, 0, 11, 16, NO_BORDER);
    m.show(loc(10, 12), 40, 0, 11, 16, BUTTON_BORDER);
    m.show(loc(10, 14), 40, 0, 11, 16, SHOW_BORDER);
    m.show(loc(60, 2), 20, 1, 11, 16, NO_BORDER);
    m.show(loc(65, 2), 20, 1, 11, 16, BUTTON_BORDER);
    m.show(loc(70, 2), 20, 1, 11, 16, SHOW_BORDER);

    close_KNOW_HOW();
    closegraph();
    }
*/