//  KIT.H  common part of object and application containers.

#ifndef __KIT_H_
#define __KIT_H_

#include "visible.h"
#include <alloc.h>
#include <string.h>

#define DELTA 20
    // step in reallocation of the memory for list

class Kit
    {
    protected:
	Visible** list;     // objects in the Kit
	int current;        // number of the current object
	int used;           // total number of objects in container
	int size;           // allocated >= used
	char* help_context; // help context of container

    public:
	Kit();

	virtual ~Kit();

	void set_help_context(char* hName);
	int pos() { return current; }
	int add(Visible* object);  // add object to the end of the list

	Visible* get(int number) { return list[number]; }
	int get(Visible*);       // return No in the container. ATTENTION!
				 // returns FIRST occurrence of pointer!

	int moveTo(int number)
	    {
	    if(number <= used)
		current = number;
	    return current;
	    }

	int shift()  // go to the next object
	    {
	    current = (current < used) ? current + 1 : 1;
		      return current;
	    }
	Visible* remove(int number);    // remove from list but doesn't delete
	void insert(Visible* object, int number); // add to the current position
				     // and shift objects with largest numbers
	void background(Visible* back_object) { list[0] = back_object; }
	     // this is "supply" object, of Window class, which is present in
	     // Kit, but is not listed during iterations
    };


#endif __KIT_H_
