#include "imagebuf.h"


unsigned char ImageBuffer::image_get_pixel(imageP image, int byte,
	int vert_shift)
    {
    int line_size = (image->xmax + 8) >> 3;

    unsigned char pix, plane;
    int work_byte = byte;
    pixels[0] = pixels[1] = pixels[2] = pixels[3] = pixels[4] = pixels[5]
	= pixels[6] = pixels[7] = 0;
    for(plane = 0; plane < 4; plane++, work_byte += line_size)
	{
	pix = image->data[work_byte];
	for(int X = 0; X < 8; X++)
	    {
	    int step = (7 - X);
	    pixels[X] = pixels[X]
		 | (((pix >> step) & 1) << (4 - plane - 1));
	    }
	}
    int x = byte << 3;
    for(int k = 0; k < 8; k++)
	pixels[k] = bw_pix((uchar)(pixels[k]), x + k, vert_shift);
    return (pixels[0] << 7)
	    | (pixels[1] << 6)
	    | (pixels[2] << 5)
	    | (pixels[3] << 4)
	    | (pixels[4] << 3)
	    | (pixels[5] << 2)
	    | (pixels[6] << 1)
	    | pixels[7];
    }
//////////////////////
