#include "border.h"

Border::Border(rect coordinates, char* h, BORDERS b_type, BORDERS hdr_b_type,
               int s, int pat)
    : Header(h, screenXL(coordinates.width() - 1)
	     - area[b_type].origin.X - area[b_type].corner.X
             - area[hdr_b_type].origin.X - area[hdr_b_type].corner.X
	     - 2 * s, hdr_b_type, pat),
      Frame(coordinates, b_type, s)
      {
      }
////////////////////
void Border::show()
    {
    Frame::show();
    Header::show(loc(screenXL(rectangle.origin.X)
	+ area[border_type].origin.X,
	screenYT(rectangle.origin.Y)
	+ area[border_type].origin.Y) + shadow);
    }
/////////////////////
void Border::hilite()                 { Frame::hilite(); }
void Border::unhilite()               { Frame::unhilite(); }
void Border::set_header(char* h)
    {
    if(header != NULL)
        {
	delete header;
	header = strdup(h);
	}
    }
/////////////////////////
void Border::set_type(BORDERS type)   { border_type = type; }
/////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
        return;
    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    Border b(rect(1, 1, 40, 6), "HELLO, World !", BUTTON_BORDER,
        SHOW_BORDER, 16, 16);
    b.show();
    Border b1(rect(1, 7, 40, 12), "HELLO, World !", STANDART_BORDER,
        STANDART_BORDER, 16, 16);
    b1.show();
    Border b2(rect(1, 13, 40, 17), "HELLO, World !", SHOW_BORDER,
        NO_BORDER, 16, 16);
    b2.show();
    Border b3(rect(1, 18, 40, 22), "HELLO, World !", PRESS_BORDER,
        BUTTON_BORDER, 16, 16);
    b3.show();

    close_KNOW_HOW();
    closegraph();
    }
*/